<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activity StructType
 * @subpackage Structs
 */
class Activity extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The ActivityDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityDate;
    /**
     * The TimeSpent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Timespan
     */
    public $TimeSpent;
    /**
     * Constructor method for Activity
     * @uses Activity::setType()
     * @uses Activity::setActivityDate()
     * @uses Activity::setTimeSpent()
     * @param string $type
     * @param string $activityDate
     * @param \StructType\Timespan $timeSpent
     */
    public function __construct($type = null, $activityDate = null, \StructType\Timespan $timeSpent = null)
    {
        $this
            ->setType($type)
            ->setActivityDate($activityDate)
            ->setTimeSpent($timeSpent);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ActivityType::valueIsValid()
     * @uses \EnumType\ActivityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Activity
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ActivityType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get ActivityDate value
     * @return string|null
     */
    public function getActivityDate()
    {
        return $this->ActivityDate;
    }
    /**
     * Set ActivityDate value
     * @param string $activityDate
     * @return \StructType\Activity
     */
    public function setActivityDate($activityDate = null)
    {
        // validation for constraint: string
        if (!is_null($activityDate) && !is_string($activityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityDate)), __LINE__);
        }
        $this->ActivityDate = $activityDate;
        return $this;
    }
    /**
     * Get TimeSpent value
     * @return \StructType\Timespan|null
     */
    public function getTimeSpent()
    {
        return $this->TimeSpent;
    }
    /**
     * Set TimeSpent value
     * @param \StructType\Timespan $timeSpent
     * @return \StructType\Activity
     */
    public function setTimeSpent(\StructType\Timespan $timeSpent = null)
    {
        $this->TimeSpent = $timeSpent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Activity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
