<?php

namespace RegistrationSrvc;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel RegistrationSrvc
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelRegistration
     * Meta informations extracted from the WSDL
     * - documentation: Cancels the registration.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=RegistrationService&m=CancelRegistration'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelRegistration $parameters
     * @return \StructType\CancelRegistrationResponse|bool
     */
    public function CancelRegistration(\StructType\CancelRegistration $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelRegistration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelRegistrationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
