<?php

namespace EnumType;

/**
 * This class stands for RegistrationStatus EnumType
 * @subpackage Enumerations
 */
class RegistrationStatus
{
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Unprocessed'
     * @return string 'Unprocessed'
     */
    const VALUE_UNPROCESSED = 'Unprocessed';
    /**
     * Constant for value 'Upcoming'
     * @return string 'Upcoming'
     */
    const VALUE_UPCOMING = 'Upcoming';
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Incomplete'
     * @return string 'Incomplete'
     */
    const VALUE_INCOMPLETE = 'Incomplete';
    /**
     * Constant for value 'Complete'
     * @return string 'Complete'
     */
    const VALUE_COMPLETE = 'Complete';
    /**
     * Constant for value 'Suspended'
     * @return string 'Suspended'
     */
    const VALUE_SUSPENDED = 'Suspended';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_UNPROCESSED
     * @uses self::VALUE_UPCOMING
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_INCOMPLETE
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_UNPROCESSED,
            self::VALUE_UPCOMING,
            self::VALUE_ACTIVE,
            self::VALUE_INCOMPLETE,
            self::VALUE_COMPLETE,
            self::VALUE_SUSPENDED,
            self::VALUE_CANCELED,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
