<?php

namespace EnumType;

/**
 * This class stands for ErrorCode EnumType
 * @subpackage Enumerations
 */
class ErrorCode
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'InvalidParameter'
     * @return string 'InvalidParameter'
     */
    const VALUE_INVALID_PARAMETER = 'InvalidParameter';
    /**
     * Constant for value 'MissingParameter'
     * @return string 'MissingParameter'
     */
    const VALUE_MISSING_PARAMETER = 'MissingParameter';
    /**
     * Constant for value 'DuplicateParameter'
     * @return string 'DuplicateParameter'
     */
    const VALUE_DUPLICATE_PARAMETER = 'DuplicateParameter';
    /**
     * Constant for value 'UnknownServerError'
     * @return string 'UnknownServerError'
     */
    const VALUE_UNKNOWN_SERVER_ERROR = 'UnknownServerError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_INVALID_PARAMETER
     * @uses self::VALUE_MISSING_PARAMETER
     * @uses self::VALUE_DUPLICATE_PARAMETER
     * @uses self::VALUE_UNKNOWN_SERVER_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_INVALID_PARAMETER,
            self::VALUE_MISSING_PARAMETER,
            self::VALUE_DUPLICATE_PARAMETER,
            self::VALUE_UNKNOWN_SERVER_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
