<?php

namespace EnumType;

/**
 * This class stands for ActivityType EnumType
 * @subpackage Enumerations
 */
class ActivityType
{
    /**
     * Constant for value 'Online'
     * @return string 'Online'
     */
    const VALUE_ONLINE = 'Online';
    /**
     * Constant for value 'Offline'
     * @return string 'Offline'
     */
    const VALUE_OFFLINE = 'Offline';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONLINE
     * @uses self::VALUE_OFFLINE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLINE,
            self::VALUE_OFFLINE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
