<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString2 extends AbstractStructArrayBase
{
    /**
     * The CustomStudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CustomStudentKey;
    /**
     * Constructor method for ArrayOfString2
     * @uses ArrayOfString2::setCustomStudentKey()
     * @param string[] $customStudentKey
     */
    public function __construct(array $customStudentKey = array())
    {
        $this
            ->setCustomStudentKey($customStudentKey);
    }
    /**
     * Get CustomStudentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCustomStudentKey()
    {
        return isset($this->CustomStudentKey) ? $this->CustomStudentKey : null;
    }
    /**
     * Set CustomStudentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $customStudentKey
     * @return \ArrayType\ArrayOfString2
     */
    public function setCustomStudentKey(array $customStudentKey = array())
    {
        foreach ($customStudentKey as $arrayOfString2CustomStudentKeyItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString2CustomStudentKeyItem)) {
                throw new \InvalidArgumentException(sprintf('The CustomStudentKey property can only contain items of string, "%s" given', is_object($arrayOfString2CustomStudentKeyItem) ? get_class($arrayOfString2CustomStudentKeyItem) : gettype($arrayOfString2CustomStudentKeyItem)), __LINE__);
            }
        }
        if (is_null($customStudentKey) || (is_array($customStudentKey) && empty($customStudentKey))) {
            unset($this->CustomStudentKey);
        } else {
            $this->CustomStudentKey = $customStudentKey;
        }
        return $this;
    }
    /**
     * Add item to CustomStudentKey value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString2
     */
    public function addToCustomStudentKey($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CustomStudentKey property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomStudentKey[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomStudentKey
     */
    public function getAttributeName()
    {
        return 'CustomStudentKey';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
