<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.ed2go.com/sandbox/api/4.1/RegistrationService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.ed2go.com/sandbox/api/4.1/RegistrationService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \RegistrationSrvc\Add($options);
/**
 * Sample call for AddRegistration operation/method
 */
if ($add->AddRegistration(new \StructType\AddRegistration()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \RegistrationSrvc\Cancel($options);
/**
 * Sample call for CancelRegistration operation/method
 */
if ($cancel->CancelRegistration(new \StructType\CancelRegistration()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \RegistrationSrvc\Get($options);
/**
 * Sample call for GetRegistrationActivityReport operation/method
 */
if ($get->GetRegistrationActivityReport(new \StructType\GetRegistrationActivityReport()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRegistrationProgressReport operation/method
 */
if ($get->GetRegistrationProgressReport(new \StructType\GetRegistrationProgressReport()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRegistrations operation/method
 */
if ($get->GetRegistrations(new \StructType\GetRegistrations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSingleSignOn operation/method
 */
if ($get->GetSingleSignOn(new \StructType\GetSingleSignOn()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \RegistrationSrvc\Update($options);
/**
 * Sample call for UpdateRegistration operation/method
 */
if ($update->UpdateRegistration(new \StructType\UpdateRegistration()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
