<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRegistration StructType
 * @subpackage Structs
 */
class UpdateRegistration extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The RegistrationKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationKey;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Tags;
    /**
     * Constructor method for UpdateRegistration
     * @uses UpdateRegistration::setAPIKey()
     * @uses UpdateRegistration::setRegistrationKey()
     * @uses UpdateRegistration::setTags()
     * @param string $aPIKey
     * @param string $registrationKey
     * @param \ArrayType\ArrayOfString $tags
     */
    public function __construct($aPIKey = null, $registrationKey = null, \ArrayType\ArrayOfString $tags = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setRegistrationKey($registrationKey)
            ->setTags($tags);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\UpdateRegistration
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get RegistrationKey value
     * @return string|null
     */
    public function getRegistrationKey()
    {
        return $this->RegistrationKey;
    }
    /**
     * Set RegistrationKey value
     * @param string $registrationKey
     * @return \StructType\UpdateRegistration
     */
    public function setRegistrationKey($registrationKey = null)
    {
        // validation for constraint: string
        if (!is_null($registrationKey) && !is_string($registrationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationKey)), __LINE__);
        }
        $this->RegistrationKey = $registrationKey;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfString $tags
     * @return \StructType\UpdateRegistration
     */
    public function setTags(\ArrayType\ArrayOfString $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateRegistration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
