<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Registration StructType
 * @subpackage Structs
 */
class Registration extends AbstractStructBase
{
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The RegistrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $RegistrationDate;
    /**
     * The StudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GUID
     */
    public $StudentKey;
    /**
     * The CustomStudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomStudentKey;
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourseCode;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SectionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SectionNumber;
    /**
     * The RetailPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $RetailPrice;
    /**
     * The AccessStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $AccessStartDate;
    /**
     * The AccessEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $AccessEndDate;
    /**
     * The Custom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Custom
     */
    public $Custom;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Tags;
    /**
     * The RegistrationKey
     * @var string
     */
    public $RegistrationKey;
    /**
     * Constructor method for Registration
     * @uses Registration::setLastModifiedDate()
     * @uses Registration::setRegistrationDate()
     * @uses Registration::setStudentKey()
     * @uses Registration::setCustomStudentKey()
     * @uses Registration::setCourseCode()
     * @uses Registration::setStatus()
     * @uses Registration::setSectionNumber()
     * @uses Registration::setRetailPrice()
     * @uses Registration::setAccessStartDate()
     * @uses Registration::setAccessEndDate()
     * @uses Registration::setCustom()
     * @uses Registration::setTags()
     * @uses Registration::setRegistrationKey()
     * @param string $lastModifiedDate
     * @param \StructType\Date $registrationDate
     * @param \StructType\GUID $studentKey
     * @param string $customStudentKey
     * @param string $courseCode
     * @param string $status
     * @param string $sectionNumber
     * @param \StructType\Price $retailPrice
     * @param \StructType\Date $accessStartDate
     * @param \StructType\Date $accessEndDate
     * @param \StructType\Custom $custom
     * @param \ArrayType\ArrayOfString $tags
     * @param string $registrationKey
     */
    public function __construct($lastModifiedDate = null, \StructType\Date $registrationDate = null, \StructType\GUID $studentKey = null, $customStudentKey = null, $courseCode = null, $status = null, $sectionNumber = null, \StructType\Price $retailPrice = null, \StructType\Date $accessStartDate = null, \StructType\Date $accessEndDate = null, \StructType\Custom $custom = null, \ArrayType\ArrayOfString $tags = null, $registrationKey = null)
    {
        $this
            ->setLastModifiedDate($lastModifiedDate)
            ->setRegistrationDate($registrationDate)
            ->setStudentKey($studentKey)
            ->setCustomStudentKey($customStudentKey)
            ->setCourseCode($courseCode)
            ->setStatus($status)
            ->setSectionNumber($sectionNumber)
            ->setRetailPrice($retailPrice)
            ->setAccessStartDate($accessStartDate)
            ->setAccessEndDate($accessEndDate)
            ->setCustom($custom)
            ->setTags($tags)
            ->setRegistrationKey($registrationKey);
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Registration
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get RegistrationDate value
     * @return \StructType\Date|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param \StructType\Date $registrationDate
     * @return \StructType\Registration
     */
    public function setRegistrationDate(\StructType\Date $registrationDate = null)
    {
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get StudentKey value
     * @return \StructType\GUID|null
     */
    public function getStudentKey()
    {
        return $this->StudentKey;
    }
    /**
     * Set StudentKey value
     * @param \StructType\GUID $studentKey
     * @return \StructType\Registration
     */
    public function setStudentKey(\StructType\GUID $studentKey = null)
    {
        $this->StudentKey = $studentKey;
        return $this;
    }
    /**
     * Get CustomStudentKey value
     * @return string|null
     */
    public function getCustomStudentKey()
    {
        return $this->CustomStudentKey;
    }
    /**
     * Set CustomStudentKey value
     * @param string $customStudentKey
     * @return \StructType\Registration
     */
    public function setCustomStudentKey($customStudentKey = null)
    {
        // validation for constraint: string
        if (!is_null($customStudentKey) && !is_string($customStudentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customStudentKey)), __LINE__);
        }
        $this->CustomStudentKey = $customStudentKey;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\Registration
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\RegistrationStatus::valueIsValid()
     * @uses \EnumType\RegistrationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Registration
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegistrationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\RegistrationStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SectionNumber value
     * @return string|null
     */
    public function getSectionNumber()
    {
        return $this->SectionNumber;
    }
    /**
     * Set SectionNumber value
     * @param string $sectionNumber
     * @return \StructType\Registration
     */
    public function setSectionNumber($sectionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sectionNumber) && !is_string($sectionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sectionNumber)), __LINE__);
        }
        $this->SectionNumber = $sectionNumber;
        return $this;
    }
    /**
     * Get RetailPrice value
     * @return \StructType\Price|null
     */
    public function getRetailPrice()
    {
        return $this->RetailPrice;
    }
    /**
     * Set RetailPrice value
     * @param \StructType\Price $retailPrice
     * @return \StructType\Registration
     */
    public function setRetailPrice(\StructType\Price $retailPrice = null)
    {
        $this->RetailPrice = $retailPrice;
        return $this;
    }
    /**
     * Get AccessStartDate value
     * @return \StructType\Date|null
     */
    public function getAccessStartDate()
    {
        return $this->AccessStartDate;
    }
    /**
     * Set AccessStartDate value
     * @param \StructType\Date $accessStartDate
     * @return \StructType\Registration
     */
    public function setAccessStartDate(\StructType\Date $accessStartDate = null)
    {
        $this->AccessStartDate = $accessStartDate;
        return $this;
    }
    /**
     * Get AccessEndDate value
     * @return \StructType\Date|null
     */
    public function getAccessEndDate()
    {
        return $this->AccessEndDate;
    }
    /**
     * Set AccessEndDate value
     * @param \StructType\Date $accessEndDate
     * @return \StructType\Registration
     */
    public function setAccessEndDate(\StructType\Date $accessEndDate = null)
    {
        $this->AccessEndDate = $accessEndDate;
        return $this;
    }
    /**
     * Get Custom value
     * @return \StructType\Custom|null
     */
    public function getCustom()
    {
        return $this->Custom;
    }
    /**
     * Set Custom value
     * @param \StructType\Custom $custom
     * @return \StructType\Registration
     */
    public function setCustom(\StructType\Custom $custom = null)
    {
        $this->Custom = $custom;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfString $tags
     * @return \StructType\Registration
     */
    public function setTags(\ArrayType\ArrayOfString $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Get RegistrationKey value
     * @return string|null
     */
    public function getRegistrationKey()
    {
        return $this->RegistrationKey;
    }
    /**
     * Set RegistrationKey value
     * @param string $registrationKey
     * @return \StructType\Registration
     */
    public function setRegistrationKey($registrationKey = null)
    {
        // validation for constraint: string
        if (!is_null($registrationKey) && !is_string($registrationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationKey)), __LINE__);
        }
        $this->RegistrationKey = $registrationKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Registration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
