<?php

namespace RegistrationSrvc;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get RegistrationSrvc
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetRegistrationActivityReport
     * Meta informations extracted from the WSDL
     * - documentation: Gets activity report for the registration.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=RegistrationService&m=GetRegistrationActivityReport'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegistrationActivityReport $parameters
     * @return \StructType\GetRegistrationActivityReportResponse|bool
     */
    public function GetRegistrationActivityReport(\StructType\GetRegistrationActivityReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRegistrationActivityReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegistrationProgressReport
     * Meta informations extracted from the WSDL
     * - documentation: Gets progress report for the registration.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=RegistrationService&m=GetRegistrationProgressReport'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegistrationProgressReport $parameters
     * @return \StructType\GetRegistrationProgressReportResponse|bool
     */
    public function GetRegistrationProgressReport(\StructType\GetRegistrationProgressReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRegistrationProgressReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegistrations
     * Meta informations extracted from the WSDL
     * - documentation: Gets registrations using filter criteria.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=RegistrationService&m=GetRegistrations'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegistrations $parameters
     * @return \StructType\GetRegistrationsResponse|bool
     */
    public function GetRegistrations(\StructType\GetRegistrations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRegistrations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSingleSignOn
     * Meta informations extracted from the WSDL
     * - documentation: Gets single sign on url for this registration.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=RegistrationService&m=GetSingleSignOn'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSingleSignOn $parameters
     * @return \StructType\GetSingleSignOnResponse|bool
     */
    public function GetSingleSignOn(\StructType\GetSingleSignOn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSingleSignOn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetRegistrationActivityReportResponse|\StructType\GetRegistrationProgressReportResponse|\StructType\GetRegistrationsResponse|\StructType\GetSingleSignOnResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
