<?php

namespace RegistrationSrvc;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add RegistrationSrvc
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddRegistration
     * Meta informations extracted from the WSDL
     * - documentation: Adds a new registration.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=RegistrationService&m=AddRegistration'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRegistration $parameters
     * @return \StructType\AddRegistrationResponse|bool
     */
    public function AddRegistration(\StructType\AddRegistration $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddRegistration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddRegistrationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
