<?php

namespace EnumType;

/**
 * This class stands for RegistrationIncludeField4_1 EnumType
 * @subpackage Enumerations
 */
class RegistrationIncludeField4_1
{
    /**
     * Constant for value 'AccessEndDate'
     * @return string 'AccessEndDate'
     */
    const VALUE_ACCESS_END_DATE = 'AccessEndDate';
    /**
     * Constant for value 'AccessStartDate'
     * @return string 'AccessStartDate'
     */
    const VALUE_ACCESS_START_DATE = 'AccessStartDate';
    /**
     * Constant for value 'CourseCode'
     * @return string 'CourseCode'
     */
    const VALUE_COURSE_CODE = 'CourseCode';
    /**
     * Constant for value 'Custom'
     * @return string 'Custom'
     */
    const VALUE_CUSTOM = 'Custom';
    /**
     * Constant for value 'CustomStudentKey'
     * @return string 'CustomStudentKey'
     */
    const VALUE_CUSTOM_STUDENT_KEY = 'CustomStudentKey';
    /**
     * Constant for value 'LastModifiedDate'
     * @return string 'LastModifiedDate'
     */
    const VALUE_LAST_MODIFIED_DATE = 'LastModifiedDate';
    /**
     * Constant for value 'RegistrationDate'
     * @return string 'RegistrationDate'
     */
    const VALUE_REGISTRATION_DATE = 'RegistrationDate';
    /**
     * Constant for value 'RetailPrice'
     * @return string 'RetailPrice'
     */
    const VALUE_RETAIL_PRICE = 'RetailPrice';
    /**
     * Constant for value 'SectionNumber'
     * @return string 'SectionNumber'
     */
    const VALUE_SECTION_NUMBER = 'SectionNumber';
    /**
     * Constant for value 'Status'
     * @return string 'Status'
     */
    const VALUE_STATUS = 'Status';
    /**
     * Constant for value 'StudentKey'
     * @return string 'StudentKey'
     */
    const VALUE_STUDENT_KEY = 'StudentKey';
    /**
     * Constant for value 'Tags'
     * @return string 'Tags'
     */
    const VALUE_TAGS = 'Tags';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCESS_END_DATE
     * @uses self::VALUE_ACCESS_START_DATE
     * @uses self::VALUE_COURSE_CODE
     * @uses self::VALUE_CUSTOM
     * @uses self::VALUE_CUSTOM_STUDENT_KEY
     * @uses self::VALUE_LAST_MODIFIED_DATE
     * @uses self::VALUE_REGISTRATION_DATE
     * @uses self::VALUE_RETAIL_PRICE
     * @uses self::VALUE_SECTION_NUMBER
     * @uses self::VALUE_STATUS
     * @uses self::VALUE_STUDENT_KEY
     * @uses self::VALUE_TAGS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCESS_END_DATE,
            self::VALUE_ACCESS_START_DATE,
            self::VALUE_COURSE_CODE,
            self::VALUE_CUSTOM,
            self::VALUE_CUSTOM_STUDENT_KEY,
            self::VALUE_LAST_MODIFIED_DATE,
            self::VALUE_REGISTRATION_DATE,
            self::VALUE_RETAIL_PRICE,
            self::VALUE_SECTION_NUMBER,
            self::VALUE_STATUS,
            self::VALUE_STUDENT_KEY,
            self::VALUE_TAGS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
