<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegistrationStatus ArrayType
 * @subpackage Arrays
 */
class ArrayOfRegistrationStatus extends AbstractStructArrayBase
{
    /**
     * The RegistrationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $RegistrationStatus;
    /**
     * Constructor method for ArrayOfRegistrationStatus
     * @uses ArrayOfRegistrationStatus::setRegistrationStatus()
     * @param string[] $registrationStatus
     */
    public function __construct(array $registrationStatus = array())
    {
        $this
            ->setRegistrationStatus($registrationStatus);
    }
    /**
     * Get RegistrationStatus value
     * @return string[]|null
     */
    public function getRegistrationStatus()
    {
        return $this->RegistrationStatus;
    }
    /**
     * Set RegistrationStatus value
     * @uses \EnumType\RegistrationStatus::valueIsValid()
     * @uses \EnumType\RegistrationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $registrationStatus
     * @return \ArrayType\ArrayOfRegistrationStatus
     */
    public function setRegistrationStatus(array $registrationStatus = array())
    {
        $invalidValues = array();
        foreach ($registrationStatus as $arrayOfRegistrationStatusRegistrationStatusItem) {
            if (!\EnumType\RegistrationStatus::valueIsValid($arrayOfRegistrationStatusRegistrationStatusItem)) {
                $invalidValues[] = var_export($arrayOfRegistrationStatusRegistrationStatusItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\RegistrationStatus::getValidValues())), __LINE__);
        }
        $this->RegistrationStatus = $registrationStatus;
        return $this;
    }
    /**
     * Add item to RegistrationStatus value
     * @uses \EnumType\RegistrationStatus::valueIsValid()
     * @uses \EnumType\RegistrationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfRegistrationStatus
     */
    public function addToRegistrationStatus($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegistrationStatus::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RegistrationStatus::getValidValues())), __LINE__);
        }
        $this->RegistrationStatus[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\RegistrationStatus::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfRegistrationStatus
     */
    public function add($item)
    {
        if (!\EnumType\RegistrationStatus::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RegistrationStatus::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RegistrationStatus
     */
    public function getAttributeName()
    {
        return 'RegistrationStatus';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRegistrationStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
