<?php

namespace StudentMgmt;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update StudentMgmt
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateStudent
     * Meta informations extracted from the WSDL
     * - documentation: Updates student info. NOTE: Excluded elements = leave as is. To remove data from fields: CustomStudentKey or Address2, pass element with empty value.<br/>&nbsp;<i>For details see <a
     * href='./Instructions.aspx?s=StudentManagerService&m=UpdateStudent'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateStudent $parameters
     * @return \StructType\UpdateStudentResponse|bool
     */
    public function UpdateStudent(\StructType\UpdateStudent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateStudent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateStudentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
