<?php

namespace StudentMgmt;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add StudentMgmt
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddStudent
     * Meta informations extracted from the WSDL
     * - documentation: Adds a new student.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=StudentManagerService&m=AddStudent'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddStudent $parameters
     * @return \StructType\AddStudentResponse|bool
     */
    public function AddStudent(\StructType\AddStudent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddStudent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddStudentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
