<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateStudent StructType
 * @subpackage Structs
 */
class UpdateStudent extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The StudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StudentKey;
    /**
     * The CustomStudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomStudentKey;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Tags;
    /**
     * Constructor method for UpdateStudent
     * @uses UpdateStudent::setAddress()
     * @uses UpdateStudent::setAPIKey()
     * @uses UpdateStudent::setStudentKey()
     * @uses UpdateStudent::setCustomStudentKey()
     * @uses UpdateStudent::setFirstName()
     * @uses UpdateStudent::setLastName()
     * @uses UpdateStudent::setEmail()
     * @uses UpdateStudent::setTags()
     * @param \StructType\Address $address
     * @param string $aPIKey
     * @param string $studentKey
     * @param string $customStudentKey
     * @param string $firstName
     * @param string $lastName
     * @param string $email
     * @param \ArrayType\ArrayOfString $tags
     */
    public function __construct(\StructType\Address $address = null, $aPIKey = null, $studentKey = null, $customStudentKey = null, $firstName = null, $lastName = null, $email = null, \ArrayType\ArrayOfString $tags = null)
    {
        $this
            ->setAddress($address)
            ->setAPIKey($aPIKey)
            ->setStudentKey($studentKey)
            ->setCustomStudentKey($customStudentKey)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setTags($tags);
    }
    /**
     * Get Address value
     * @return \StructType\Address
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\UpdateStudent
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\UpdateStudent
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get StudentKey value
     * @return string|null
     */
    public function getStudentKey()
    {
        return $this->StudentKey;
    }
    /**
     * Set StudentKey value
     * @param string $studentKey
     * @return \StructType\UpdateStudent
     */
    public function setStudentKey($studentKey = null)
    {
        // validation for constraint: string
        if (!is_null($studentKey) && !is_string($studentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentKey)), __LINE__);
        }
        $this->StudentKey = $studentKey;
        return $this;
    }
    /**
     * Get CustomStudentKey value
     * @return string|null
     */
    public function getCustomStudentKey()
    {
        return $this->CustomStudentKey;
    }
    /**
     * Set CustomStudentKey value
     * @param string $customStudentKey
     * @return \StructType\UpdateStudent
     */
    public function setCustomStudentKey($customStudentKey = null)
    {
        // validation for constraint: string
        if (!is_null($customStudentKey) && !is_string($customStudentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customStudentKey)), __LINE__);
        }
        $this->CustomStudentKey = $customStudentKey;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\UpdateStudent
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\UpdateStudent
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\UpdateStudent
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfString $tags
     * @return \StructType\UpdateStudent
     */
    public function setTags(\ArrayType\ArrayOfString $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateStudent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
