<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StudentsFilter StructType
 * @subpackage Structs
 */
class StudentsFilter extends AbstractStructBase
{
    /**
     * The StudentKeys
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGUID
     */
    public $StudentKeys;
    /**
     * The CustomStudentKeys
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $CustomStudentKeys;
    /**
     * The Emails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString2
     */
    public $Emails;
    /**
     * The LastNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString3
     */
    public $LastNames;
    /**
     * The CreatedDateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $CreatedDateRange;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Tags
     */
    public $Tags;
    /**
     * Constructor method for StudentsFilter
     * @uses StudentsFilter::setStudentKeys()
     * @uses StudentsFilter::setCustomStudentKeys()
     * @uses StudentsFilter::setEmails()
     * @uses StudentsFilter::setLastNames()
     * @uses StudentsFilter::setCreatedDateRange()
     * @uses StudentsFilter::setTags()
     * @param \ArrayType\ArrayOfGUID $studentKeys
     * @param \ArrayType\ArrayOfString1 $customStudentKeys
     * @param \ArrayType\ArrayOfString2 $emails
     * @param \ArrayType\ArrayOfString3 $lastNames
     * @param \StructType\DateRange $createdDateRange
     * @param \StructType\Tags $tags
     */
    public function __construct(\ArrayType\ArrayOfGUID $studentKeys = null, \ArrayType\ArrayOfString1 $customStudentKeys = null, \ArrayType\ArrayOfString2 $emails = null, \ArrayType\ArrayOfString3 $lastNames = null, \StructType\DateRange $createdDateRange = null, \StructType\Tags $tags = null)
    {
        $this
            ->setStudentKeys($studentKeys)
            ->setCustomStudentKeys($customStudentKeys)
            ->setEmails($emails)
            ->setLastNames($lastNames)
            ->setCreatedDateRange($createdDateRange)
            ->setTags($tags);
    }
    /**
     * Get StudentKeys value
     * @return \ArrayType\ArrayOfGUID|null
     */
    public function getStudentKeys()
    {
        return $this->StudentKeys;
    }
    /**
     * Set StudentKeys value
     * @param \ArrayType\ArrayOfGUID $studentKeys
     * @return \StructType\StudentsFilter
     */
    public function setStudentKeys(\ArrayType\ArrayOfGUID $studentKeys = null)
    {
        $this->StudentKeys = $studentKeys;
        return $this;
    }
    /**
     * Get CustomStudentKeys value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getCustomStudentKeys()
    {
        return $this->CustomStudentKeys;
    }
    /**
     * Set CustomStudentKeys value
     * @param \ArrayType\ArrayOfString1 $customStudentKeys
     * @return \StructType\StudentsFilter
     */
    public function setCustomStudentKeys(\ArrayType\ArrayOfString1 $customStudentKeys = null)
    {
        $this->CustomStudentKeys = $customStudentKeys;
        return $this;
    }
    /**
     * Get Emails value
     * @return \ArrayType\ArrayOfString2|null
     */
    public function getEmails()
    {
        return $this->Emails;
    }
    /**
     * Set Emails value
     * @param \ArrayType\ArrayOfString2 $emails
     * @return \StructType\StudentsFilter
     */
    public function setEmails(\ArrayType\ArrayOfString2 $emails = null)
    {
        $this->Emails = $emails;
        return $this;
    }
    /**
     * Get LastNames value
     * @return \ArrayType\ArrayOfString3|null
     */
    public function getLastNames()
    {
        return $this->LastNames;
    }
    /**
     * Set LastNames value
     * @param \ArrayType\ArrayOfString3 $lastNames
     * @return \StructType\StudentsFilter
     */
    public function setLastNames(\ArrayType\ArrayOfString3 $lastNames = null)
    {
        $this->LastNames = $lastNames;
        return $this;
    }
    /**
     * Get CreatedDateRange value
     * @return \StructType\DateRange|null
     */
    public function getCreatedDateRange()
    {
        return $this->CreatedDateRange;
    }
    /**
     * Set CreatedDateRange value
     * @param \StructType\DateRange $createdDateRange
     * @return \StructType\StudentsFilter
     */
    public function setCreatedDateRange(\StructType\DateRange $createdDateRange = null)
    {
        $this->CreatedDateRange = $createdDateRange;
        return $this;
    }
    /**
     * Get Tags value
     * @return \StructType\Tags|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \StructType\Tags $tags
     * @return \StructType\StudentsFilter
     */
    public function setTags(\StructType\Tags $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StudentsFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
