<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Form StructType
 * @subpackage Structs
 */
class Form extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Action;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInput
     */
    public $Data;
    /**
     * The Method
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Method;
    /**
     * Constructor method for Form
     * @uses Form::setAction()
     * @uses Form::setData()
     * @uses Form::setMethod()
     * @param \StructType\EncodedValue $action
     * @param \ArrayType\ArrayOfInput $data
     * @param string $method
     */
    public function __construct(\StructType\EncodedValue $action = null, \ArrayType\ArrayOfInput $data = null, $method = null)
    {
        $this
            ->setAction($action)
            ->setData($data)
            ->setMethod($method);
    }
    /**
     * Get Action value
     * @return \StructType\EncodedValue|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param \StructType\EncodedValue $action
     * @return \StructType\Form
     */
    public function setAction(\StructType\EncodedValue $action = null)
    {
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Data value
     * @return \ArrayType\ArrayOfInput|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \ArrayType\ArrayOfInput $data
     * @return \StructType\Form
     */
    public function setData(\ArrayType\ArrayOfInput $data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Method value
     * @return string|null
     */
    public function getMethod()
    {
        return $this->Method;
    }
    /**
     * Set Method value
     * @param string $method
     * @return \StructType\Form
     */
    public function setMethod($method = null)
    {
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($method)), __LINE__);
        }
        $this->Method = $method;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Form
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
