<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStudent ArrayType
 * @subpackage Arrays
 */
class ArrayOfStudent extends AbstractStructArrayBase
{
    /**
     * The Student
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Student[]
     */
    public $Student;
    /**
     * Constructor method for ArrayOfStudent
     * @uses ArrayOfStudent::setStudent()
     * @param \StructType\Student[] $student
     */
    public function __construct(array $student = array())
    {
        $this
            ->setStudent($student);
    }
    /**
     * Get Student value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Student[]|null
     */
    public function getStudent()
    {
        return isset($this->Student) ? $this->Student : null;
    }
    /**
     * Set Student value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Student[] $student
     * @return \ArrayType\ArrayOfStudent
     */
    public function setStudent(array $student = array())
    {
        foreach ($student as $arrayOfStudentStudentItem) {
            // validation for constraint: itemType
            if (!$arrayOfStudentStudentItem instanceof \StructType\Student) {
                throw new \InvalidArgumentException(sprintf('The Student property can only contain items of \StructType\Student, "%s" given', is_object($arrayOfStudentStudentItem) ? get_class($arrayOfStudentStudentItem) : gettype($arrayOfStudentStudentItem)), __LINE__);
            }
        }
        if (is_null($student) || (is_array($student) && empty($student))) {
            unset($this->Student);
        } else {
            $this->Student = $student;
        }
        return $this;
    }
    /**
     * Add item to Student value
     * @throws \InvalidArgumentException
     * @param \StructType\Student $item
     * @return \ArrayType\ArrayOfStudent
     */
    public function addToStudent(\StructType\Student $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Student) {
            throw new \InvalidArgumentException(sprintf('The Student property can only contain items of \StructType\Student, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Student[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Student|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Student|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Student|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Student|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Student|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Student
     */
    public function getAttributeName()
    {
        return 'Student';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStudent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
