<?php

namespace StudentMgmt;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get StudentMgmt
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSingleSignOn
     * Meta informations extracted from the WSDL
     * - documentation: Gets single sign on url for this student.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=StudentManagerService&m=GetSingleSignOn'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSingleSignOn $parameters
     * @return \StructType\GetSingleSignOnResponse|bool
     */
    public function GetSingleSignOn(\StructType\GetSingleSignOn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSingleSignOn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStudents
     * Meta informations extracted from the WSDL
     * - documentation: Gets students using filter criteria.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=StudentManagerService&m=GetStudents'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStudents $parameters
     * @return \StructType\GetStudentsResponse|bool
     */
    public function GetStudents(\StructType\GetStudents $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStudents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetSingleSignOnResponse|\StructType\GetStudentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
