<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Student StructType
 * @subpackage Structs
 */
class Student extends AbstractStructBase
{
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $CreatedDate;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Custom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Custom
     */
    public $Custom;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Tags;
    /**
     * The StudentKey
     * @var string
     */
    public $StudentKey;
    /**
     * The CustomStudentKey
     * @var string
     */
    public $CustomStudentKey;
    /**
     * Constructor method for Student
     * @uses Student::setEmail()
     * @uses Student::setFirstName()
     * @uses Student::setLastName()
     * @uses Student::setCreatedDate()
     * @uses Student::setAddress()
     * @uses Student::setCustom()
     * @uses Student::setTags()
     * @uses Student::setStudentKey()
     * @uses Student::setCustomStudentKey()
     * @param string $email
     * @param string $firstName
     * @param string $lastName
     * @param \StructType\Date $createdDate
     * @param \StructType\Address $address
     * @param \StructType\Custom $custom
     * @param \ArrayType\ArrayOfString $tags
     * @param string $studentKey
     * @param string $customStudentKey
     */
    public function __construct($email = null, $firstName = null, $lastName = null, \StructType\Date $createdDate = null, \StructType\Address $address = null, \StructType\Custom $custom = null, \ArrayType\ArrayOfString $tags = null, $studentKey = null, $customStudentKey = null)
    {
        $this
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCreatedDate($createdDate)
            ->setAddress($address)
            ->setCustom($custom)
            ->setTags($tags)
            ->setStudentKey($studentKey)
            ->setCustomStudentKey($customStudentKey);
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Student
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Student
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Student
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return \StructType\Date|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param \StructType\Date $createdDate
     * @return \StructType\Student
     */
    public function setCreatedDate(\StructType\Date $createdDate = null)
    {
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\Student
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Custom value
     * @return \StructType\Custom|null
     */
    public function getCustom()
    {
        return $this->Custom;
    }
    /**
     * Set Custom value
     * @param \StructType\Custom $custom
     * @return \StructType\Student
     */
    public function setCustom(\StructType\Custom $custom = null)
    {
        $this->Custom = $custom;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfString $tags
     * @return \StructType\Student
     */
    public function setTags(\ArrayType\ArrayOfString $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Get StudentKey value
     * @return string|null
     */
    public function getStudentKey()
    {
        return $this->StudentKey;
    }
    /**
     * Set StudentKey value
     * @param string $studentKey
     * @return \StructType\Student
     */
    public function setStudentKey($studentKey = null)
    {
        // validation for constraint: string
        if (!is_null($studentKey) && !is_string($studentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentKey)), __LINE__);
        }
        $this->StudentKey = $studentKey;
        return $this;
    }
    /**
     * Get CustomStudentKey value
     * @return string|null
     */
    public function getCustomStudentKey()
    {
        return $this->CustomStudentKey;
    }
    /**
     * Set CustomStudentKey value
     * @param string $customStudentKey
     * @return \StructType\Student
     */
    public function setCustomStudentKey($customStudentKey = null)
    {
        // validation for constraint: string
        if (!is_null($customStudentKey) && !is_string($customStudentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customStudentKey)), __LINE__);
        }
        $this->CustomStudentKey = $customStudentKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Student
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
