<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStudents StructType
 * @subpackage Structs
 */
class GetStudents extends AbstractStructBase
{
    /**
     * The StudentsFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\StudentsFilter
     */
    public $StudentsFilter;
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The IncludeFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfStudentIncludeField4_1
     */
    public $IncludeFields;
    /**
     * Constructor method for GetStudents
     * @uses GetStudents::setStudentsFilter()
     * @uses GetStudents::setAPIKey()
     * @uses GetStudents::setIncludeFields()
     * @param \StructType\StudentsFilter $studentsFilter
     * @param string $aPIKey
     * @param \ArrayType\ArrayOfStudentIncludeField4_1 $includeFields
     */
    public function __construct(\StructType\StudentsFilter $studentsFilter = null, $aPIKey = null, \ArrayType\ArrayOfStudentIncludeField4_1 $includeFields = null)
    {
        $this
            ->setStudentsFilter($studentsFilter)
            ->setAPIKey($aPIKey)
            ->setIncludeFields($includeFields);
    }
    /**
     * Get StudentsFilter value
     * @return \StructType\StudentsFilter
     */
    public function getStudentsFilter()
    {
        return $this->StudentsFilter;
    }
    /**
     * Set StudentsFilter value
     * @param \StructType\StudentsFilter $studentsFilter
     * @return \StructType\GetStudents
     */
    public function setStudentsFilter(\StructType\StudentsFilter $studentsFilter = null)
    {
        $this->StudentsFilter = $studentsFilter;
        return $this;
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetStudents
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get IncludeFields value
     * @return \ArrayType\ArrayOfStudentIncludeField4_1|null
     */
    public function getIncludeFields()
    {
        return $this->IncludeFields;
    }
    /**
     * Set IncludeFields value
     * @param \ArrayType\ArrayOfStudentIncludeField4_1 $includeFields
     * @return \StructType\GetStudents
     */
    public function setIncludeFields(\ArrayType\ArrayOfStudentIncludeField4_1 $includeFields = null)
    {
        $this->IncludeFields = $includeFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStudents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
