<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSingleSignOn StructType
 * @subpackage Structs
 */
class GetSingleSignOn extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The StudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StudentKey;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination;
    /**
     * The ReturnURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnURL;
    /**
     * Constructor method for GetSingleSignOn
     * @uses GetSingleSignOn::setAPIKey()
     * @uses GetSingleSignOn::setStudentKey()
     * @uses GetSingleSignOn::setDestination()
     * @uses GetSingleSignOn::setReturnURL()
     * @param string $aPIKey
     * @param string $studentKey
     * @param string $destination
     * @param string $returnURL
     */
    public function __construct($aPIKey = null, $studentKey = null, $destination = null, $returnURL = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setStudentKey($studentKey)
            ->setDestination($destination)
            ->setReturnURL($returnURL);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetSingleSignOn
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get StudentKey value
     * @return string|null
     */
    public function getStudentKey()
    {
        return $this->StudentKey;
    }
    /**
     * Set StudentKey value
     * @param string $studentKey
     * @return \StructType\GetSingleSignOn
     */
    public function setStudentKey($studentKey = null)
    {
        // validation for constraint: string
        if (!is_null($studentKey) && !is_string($studentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($studentKey)), __LINE__);
        }
        $this->StudentKey = $studentKey;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\GetSingleSignOn
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get ReturnURL value
     * @return string|null
     */
    public function getReturnURL()
    {
        return $this->ReturnURL;
    }
    /**
     * Set ReturnURL value
     * @param string $returnURL
     * @return \StructType\GetSingleSignOn
     */
    public function setReturnURL($returnURL = null)
    {
        // validation for constraint: string
        if (!is_null($returnURL) && !is_string($returnURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnURL)), __LINE__);
        }
        $this->ReturnURL = $returnURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSingleSignOn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
