<?php

namespace EnumType;

/**
 * This class stands for StudentIncludeField4_1 EnumType
 * @subpackage Enumerations
 */
class StudentIncludeField4_1
{
    /**
     * Constant for value 'Address'
     * @return string 'Address'
     */
    const VALUE_ADDRESS = 'Address';
    /**
     * Constant for value 'CreatedDate'
     * @return string 'CreatedDate'
     */
    const VALUE_CREATED_DATE = 'CreatedDate';
    /**
     * Constant for value 'Custom'
     * @return string 'Custom'
     */
    const VALUE_CUSTOM = 'Custom';
    /**
     * Constant for value 'Email'
     * @return string 'Email'
     */
    const VALUE_EMAIL = 'Email';
    /**
     * Constant for value 'FirstName'
     * @return string 'FirstName'
     */
    const VALUE_FIRST_NAME = 'FirstName';
    /**
     * Constant for value 'LastName'
     * @return string 'LastName'
     */
    const VALUE_LAST_NAME = 'LastName';
    /**
     * Constant for value 'Tags'
     * @return string 'Tags'
     */
    const VALUE_TAGS = 'Tags';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADDRESS
     * @uses self::VALUE_CREATED_DATE
     * @uses self::VALUE_CUSTOM
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_FIRST_NAME
     * @uses self::VALUE_LAST_NAME
     * @uses self::VALUE_TAGS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADDRESS,
            self::VALUE_CREATED_DATE,
            self::VALUE_CUSTOM,
            self::VALUE_EMAIL,
            self::VALUE_FIRST_NAME,
            self::VALUE_LAST_NAME,
            self::VALUE_TAGS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
