<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInput ArrayType
 * @subpackage Arrays
 */
class ArrayOfInput extends AbstractStructArrayBase
{
    /**
     * The Input
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Input[]
     */
    public $Input;
    /**
     * Constructor method for ArrayOfInput
     * @uses ArrayOfInput::setInput()
     * @param \StructType\Input[] $input
     */
    public function __construct(array $input = array())
    {
        $this
            ->setInput($input);
    }
    /**
     * Get Input value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Input[]|null
     */
    public function getInput()
    {
        return isset($this->Input) ? $this->Input : null;
    }
    /**
     * Set Input value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Input[] $input
     * @return \ArrayType\ArrayOfInput
     */
    public function setInput(array $input = array())
    {
        foreach ($input as $arrayOfInputInputItem) {
            // validation for constraint: itemType
            if (!$arrayOfInputInputItem instanceof \StructType\Input) {
                throw new \InvalidArgumentException(sprintf('The Input property can only contain items of \StructType\Input, "%s" given', is_object($arrayOfInputInputItem) ? get_class($arrayOfInputInputItem) : gettype($arrayOfInputInputItem)), __LINE__);
            }
        }
        if (is_null($input) || (is_array($input) && empty($input))) {
            unset($this->Input);
        } else {
            $this->Input = $input;
        }
        return $this;
    }
    /**
     * Add item to Input value
     * @throws \InvalidArgumentException
     * @param \StructType\Input $item
     * @return \ArrayType\ArrayOfInput
     */
    public function addToInput(\StructType\Input $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Input) {
            throw new \InvalidArgumentException(sprintf('The Input property can only contain items of \StructType\Input, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Input[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Input|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Input|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Input|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Input|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Input|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Input
     */
    public function getAttributeName()
    {
        return 'Input';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
