<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGUID ArrayType
 * @subpackage Arrays
 */
class ArrayOfGUID extends AbstractStructArrayBase
{
    /**
     * The StudentKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GUID[]
     */
    public $StudentKey;
    /**
     * Constructor method for ArrayOfGUID
     * @uses ArrayOfGUID::setStudentKey()
     * @param \StructType\GUID[] $studentKey
     */
    public function __construct(array $studentKey = array())
    {
        $this
            ->setStudentKey($studentKey);
    }
    /**
     * Get StudentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GUID[]|null
     */
    public function getStudentKey()
    {
        return isset($this->StudentKey) ? $this->StudentKey : null;
    }
    /**
     * Set StudentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GUID[] $studentKey
     * @return \ArrayType\ArrayOfGUID
     */
    public function setStudentKey(array $studentKey = array())
    {
        foreach ($studentKey as $arrayOfGUIDStudentKeyItem) {
            // validation for constraint: itemType
            if (!$arrayOfGUIDStudentKeyItem instanceof \StructType\GUID) {
                throw new \InvalidArgumentException(sprintf('The StudentKey property can only contain items of \StructType\GUID, "%s" given', is_object($arrayOfGUIDStudentKeyItem) ? get_class($arrayOfGUIDStudentKeyItem) : gettype($arrayOfGUIDStudentKeyItem)), __LINE__);
            }
        }
        if (is_null($studentKey) || (is_array($studentKey) && empty($studentKey))) {
            unset($this->StudentKey);
        } else {
            $this->StudentKey = $studentKey;
        }
        return $this;
    }
    /**
     * Add item to StudentKey value
     * @throws \InvalidArgumentException
     * @param \StructType\GUID $item
     * @return \ArrayType\ArrayOfGUID
     */
    public function addToStudentKey(\StructType\GUID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUID) {
            throw new \InvalidArgumentException(sprintf('The StudentKey property can only contain items of \StructType\GUID, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StudentKey[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GUID|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GUID|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GUID|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GUID|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GUID|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StudentKey
     */
    public function getAttributeName()
    {
        return 'StudentKey';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGUID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
