<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartDateRange StructType
 * @subpackage Structs
 */
class StartDateRange extends AbstractStructBase
{
    /**
     * The NoStartDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoStartDates;
    /**
     * The RangeStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $RangeStartDate;
    /**
     * The RangeEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $RangeEndDate;
    /**
     * Constructor method for StartDateRange
     * @uses StartDateRange::setNoStartDates()
     * @uses StartDateRange::setRangeStartDate()
     * @uses StartDateRange::setRangeEndDate()
     * @param bool $noStartDates
     * @param \StructType\Date $rangeStartDate
     * @param \StructType\Date $rangeEndDate
     */
    public function __construct($noStartDates = null, \StructType\Date $rangeStartDate = null, \StructType\Date $rangeEndDate = null)
    {
        $this
            ->setNoStartDates($noStartDates)
            ->setRangeStartDate($rangeStartDate)
            ->setRangeEndDate($rangeEndDate);
    }
    /**
     * Get NoStartDates value
     * @return bool
     */
    public function getNoStartDates()
    {
        return $this->NoStartDates;
    }
    /**
     * Set NoStartDates value
     * @param bool $noStartDates
     * @return \StructType\StartDateRange
     */
    public function setNoStartDates($noStartDates = null)
    {
        // validation for constraint: boolean
        if (!is_null($noStartDates) && !is_bool($noStartDates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noStartDates)), __LINE__);
        }
        $this->NoStartDates = $noStartDates;
        return $this;
    }
    /**
     * Get RangeStartDate value
     * @return \StructType\Date|null
     */
    public function getRangeStartDate()
    {
        return $this->RangeStartDate;
    }
    /**
     * Set RangeStartDate value
     * @param \StructType\Date $rangeStartDate
     * @return \StructType\StartDateRange
     */
    public function setRangeStartDate(\StructType\Date $rangeStartDate = null)
    {
        $this->RangeStartDate = $rangeStartDate;
        return $this;
    }
    /**
     * Get RangeEndDate value
     * @return \StructType\Date|null
     */
    public function getRangeEndDate()
    {
        return $this->RangeEndDate;
    }
    /**
     * Set RangeEndDate value
     * @param \StructType\Date $rangeEndDate
     * @return \StructType\StartDateRange
     */
    public function setRangeEndDate(\StructType\Date $rangeEndDate = null)
    {
        $this->RangeEndDate = $rangeEndDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartDateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
