<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCourses StructType
 * @subpackage Structs
 */
class GetCourses extends AbstractStructBase
{
    /**
     * The CoursesFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\CoursesFilter
     */
    public $CoursesFilter;
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The IncludeFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCourseIncludeField
     */
    public $IncludeFields;
    /**
     * Constructor method for GetCourses
     * @uses GetCourses::setCoursesFilter()
     * @uses GetCourses::setAPIKey()
     * @uses GetCourses::setIncludeFields()
     * @param \StructType\CoursesFilter $coursesFilter
     * @param string $aPIKey
     * @param \ArrayType\ArrayOfCourseIncludeField $includeFields
     */
    public function __construct(\StructType\CoursesFilter $coursesFilter = null, $aPIKey = null, \ArrayType\ArrayOfCourseIncludeField $includeFields = null)
    {
        $this
            ->setCoursesFilter($coursesFilter)
            ->setAPIKey($aPIKey)
            ->setIncludeFields($includeFields);
    }
    /**
     * Get CoursesFilter value
     * @return \StructType\CoursesFilter
     */
    public function getCoursesFilter()
    {
        return $this->CoursesFilter;
    }
    /**
     * Set CoursesFilter value
     * @param \StructType\CoursesFilter $coursesFilter
     * @return \StructType\GetCourses
     */
    public function setCoursesFilter(\StructType\CoursesFilter $coursesFilter = null)
    {
        $this->CoursesFilter = $coursesFilter;
        return $this;
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetCourses
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get IncludeFields value
     * @return \ArrayType\ArrayOfCourseIncludeField|null
     */
    public function getIncludeFields()
    {
        return $this->IncludeFields;
    }
    /**
     * Set IncludeFields value
     * @param \ArrayType\ArrayOfCourseIncludeField $includeFields
     * @return \StructType\GetCourses
     */
    public function setIncludeFields(\ArrayType\ArrayOfCourseIncludeField $includeFields = null)
    {
        $this->IncludeFields = $includeFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCourses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
