<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCategories StructType
 * @subpackage Structs
 */
class GetCategories extends AbstractStructBase
{
    /**
     * The APIKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIKey;
    /**
     * The CategoryIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $CategoryIDs;
    /**
     * Constructor method for GetCategories
     * @uses GetCategories::setAPIKey()
     * @uses GetCategories::setCategoryIDs()
     * @param string $aPIKey
     * @param \ArrayType\ArrayOfInt $categoryIDs
     */
    public function __construct($aPIKey = null, \ArrayType\ArrayOfInt $categoryIDs = null)
    {
        $this
            ->setAPIKey($aPIKey)
            ->setCategoryIDs($categoryIDs);
    }
    /**
     * Get APIKey value
     * @return string|null
     */
    public function getAPIKey()
    {
        return $this->APIKey;
    }
    /**
     * Set APIKey value
     * @param string $aPIKey
     * @return \StructType\GetCategories
     */
    public function setAPIKey($aPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($aPIKey) && !is_string($aPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPIKey)), __LINE__);
        }
        $this->APIKey = $aPIKey;
        return $this;
    }
    /**
     * Get CategoryIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getCategoryIDs()
    {
        return $this->CategoryIDs;
    }
    /**
     * Set CategoryIDs value
     * @param \ArrayType\ArrayOfInt $categoryIDs
     * @return \StructType\GetCategories
     */
    public function setCategoryIDs(\ArrayType\ArrayOfInt $categoryIDs = null)
    {
        $this->CategoryIDs = $categoryIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCategories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
