<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Course StructType
 * @subpackage Structs
 */
class Course extends AbstractStructBase
{
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Title;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Summary;
    /**
     * The Overview
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Overview;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Details;
    /**
     * The Outline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Outline;
    /**
     * The Objectives
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Objectives;
    /**
     * The FAQs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $FAQs;
    /**
     * The Requirements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Requirements;
    /**
     * The Prerequisites
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Prerequisites;
    /**
     * The Instructor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Instructor;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $Duration;
    /**
     * The Hours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Hours;
    /**
     * The Image
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Image;
    /**
     * The Index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Index;
    /**
     * The Demo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Demo;
    /**
     * The ReleaseDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $ReleaseDate;
    /**
     * The DiscontinueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $DiscontinueDate;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $LastModifiedDate;
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The StartDates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDate
     */
    public $StartDates;
    /**
     * The RelatedCourses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCourseCode
     */
    public $RelatedCourses;
    /**
     * The StudentReviews
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfStudentReview
     */
    public $StudentReviews;
    /**
     * The CategoryIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCategoryID
     */
    public $CategoryIDs;
    /**
     * The CourseCode
     * @var string
     */
    public $CourseCode;
    /**
     * Constructor method for Course
     * @uses Course::setTitle()
     * @uses Course::setSummary()
     * @uses Course::setOverview()
     * @uses Course::setDetails()
     * @uses Course::setOutline()
     * @uses Course::setObjectives()
     * @uses Course::setFAQs()
     * @uses Course::setRequirements()
     * @uses Course::setPrerequisites()
     * @uses Course::setInstructor()
     * @uses Course::setDuration()
     * @uses Course::setHours()
     * @uses Course::setImage()
     * @uses Course::setIndex()
     * @uses Course::setDemo()
     * @uses Course::setReleaseDate()
     * @uses Course::setDiscontinueDate()
     * @uses Course::setLastModifiedDate()
     * @uses Course::setVendorCode()
     * @uses Course::setStartDates()
     * @uses Course::setRelatedCourses()
     * @uses Course::setStudentReviews()
     * @uses Course::setCategoryIDs()
     * @uses Course::setCourseCode()
     * @param \StructType\EncodedValue $title
     * @param \StructType\EncodedValue $summary
     * @param \StructType\EncodedValue $overview
     * @param \StructType\EncodedValue $details
     * @param \StructType\EncodedValue $outline
     * @param \StructType\EncodedValue $objectives
     * @param \StructType\EncodedValue $fAQs
     * @param \StructType\EncodedValue $requirements
     * @param \StructType\EncodedValue $prerequisites
     * @param \StructType\EncodedValue $instructor
     * @param \StructType\Duration $duration
     * @param float $hours
     * @param \StructType\EncodedValue $image
     * @param \StructType\EncodedValue $index
     * @param \StructType\EncodedValue $demo
     * @param \StructType\Date $releaseDate
     * @param \StructType\Date $discontinueDate
     * @param \StructType\Date $lastModifiedDate
     * @param string $vendorCode
     * @param \ArrayType\ArrayOfDate $startDates
     * @param \ArrayType\ArrayOfCourseCode $relatedCourses
     * @param \ArrayType\ArrayOfStudentReview $studentReviews
     * @param \ArrayType\ArrayOfCategoryID $categoryIDs
     * @param string $courseCode
     */
    public function __construct(\StructType\EncodedValue $title = null, \StructType\EncodedValue $summary = null, \StructType\EncodedValue $overview = null, \StructType\EncodedValue $details = null, \StructType\EncodedValue $outline = null, \StructType\EncodedValue $objectives = null, \StructType\EncodedValue $fAQs = null, \StructType\EncodedValue $requirements = null, \StructType\EncodedValue $prerequisites = null, \StructType\EncodedValue $instructor = null, \StructType\Duration $duration = null, $hours = null, \StructType\EncodedValue $image = null, \StructType\EncodedValue $index = null, \StructType\EncodedValue $demo = null, \StructType\Date $releaseDate = null, \StructType\Date $discontinueDate = null, \StructType\Date $lastModifiedDate = null, $vendorCode = null, \ArrayType\ArrayOfDate $startDates = null, \ArrayType\ArrayOfCourseCode $relatedCourses = null, \ArrayType\ArrayOfStudentReview $studentReviews = null, \ArrayType\ArrayOfCategoryID $categoryIDs = null, $courseCode = null)
    {
        $this
            ->setTitle($title)
            ->setSummary($summary)
            ->setOverview($overview)
            ->setDetails($details)
            ->setOutline($outline)
            ->setObjectives($objectives)
            ->setFAQs($fAQs)
            ->setRequirements($requirements)
            ->setPrerequisites($prerequisites)
            ->setInstructor($instructor)
            ->setDuration($duration)
            ->setHours($hours)
            ->setImage($image)
            ->setIndex($index)
            ->setDemo($demo)
            ->setReleaseDate($releaseDate)
            ->setDiscontinueDate($discontinueDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setVendorCode($vendorCode)
            ->setStartDates($startDates)
            ->setRelatedCourses($relatedCourses)
            ->setStudentReviews($studentReviews)
            ->setCategoryIDs($categoryIDs)
            ->setCourseCode($courseCode);
    }
    /**
     * Get Title value
     * @return \StructType\EncodedValue|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param \StructType\EncodedValue $title
     * @return \StructType\Course
     */
    public function setTitle(\StructType\EncodedValue $title = null)
    {
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Summary value
     * @return \StructType\EncodedValue|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \StructType\EncodedValue $summary
     * @return \StructType\Course
     */
    public function setSummary(\StructType\EncodedValue $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get Overview value
     * @return \StructType\EncodedValue|null
     */
    public function getOverview()
    {
        return $this->Overview;
    }
    /**
     * Set Overview value
     * @param \StructType\EncodedValue $overview
     * @return \StructType\Course
     */
    public function setOverview(\StructType\EncodedValue $overview = null)
    {
        $this->Overview = $overview;
        return $this;
    }
    /**
     * Get Details value
     * @return \StructType\EncodedValue|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \StructType\EncodedValue $details
     * @return \StructType\Course
     */
    public function setDetails(\StructType\EncodedValue $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get Outline value
     * @return \StructType\EncodedValue|null
     */
    public function getOutline()
    {
        return $this->Outline;
    }
    /**
     * Set Outline value
     * @param \StructType\EncodedValue $outline
     * @return \StructType\Course
     */
    public function setOutline(\StructType\EncodedValue $outline = null)
    {
        $this->Outline = $outline;
        return $this;
    }
    /**
     * Get Objectives value
     * @return \StructType\EncodedValue|null
     */
    public function getObjectives()
    {
        return $this->Objectives;
    }
    /**
     * Set Objectives value
     * @param \StructType\EncodedValue $objectives
     * @return \StructType\Course
     */
    public function setObjectives(\StructType\EncodedValue $objectives = null)
    {
        $this->Objectives = $objectives;
        return $this;
    }
    /**
     * Get FAQs value
     * @return \StructType\EncodedValue|null
     */
    public function getFAQs()
    {
        return $this->FAQs;
    }
    /**
     * Set FAQs value
     * @param \StructType\EncodedValue $fAQs
     * @return \StructType\Course
     */
    public function setFAQs(\StructType\EncodedValue $fAQs = null)
    {
        $this->FAQs = $fAQs;
        return $this;
    }
    /**
     * Get Requirements value
     * @return \StructType\EncodedValue|null
     */
    public function getRequirements()
    {
        return $this->Requirements;
    }
    /**
     * Set Requirements value
     * @param \StructType\EncodedValue $requirements
     * @return \StructType\Course
     */
    public function setRequirements(\StructType\EncodedValue $requirements = null)
    {
        $this->Requirements = $requirements;
        return $this;
    }
    /**
     * Get Prerequisites value
     * @return \StructType\EncodedValue|null
     */
    public function getPrerequisites()
    {
        return $this->Prerequisites;
    }
    /**
     * Set Prerequisites value
     * @param \StructType\EncodedValue $prerequisites
     * @return \StructType\Course
     */
    public function setPrerequisites(\StructType\EncodedValue $prerequisites = null)
    {
        $this->Prerequisites = $prerequisites;
        return $this;
    }
    /**
     * Get Instructor value
     * @return \StructType\EncodedValue|null
     */
    public function getInstructor()
    {
        return $this->Instructor;
    }
    /**
     * Set Instructor value
     * @param \StructType\EncodedValue $instructor
     * @return \StructType\Course
     */
    public function setInstructor(\StructType\EncodedValue $instructor = null)
    {
        $this->Instructor = $instructor;
        return $this;
    }
    /**
     * Get Duration value
     * @return \StructType\Duration|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param \StructType\Duration $duration
     * @return \StructType\Course
     */
    public function setDuration(\StructType\Duration $duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Hours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHours()
    {
        return isset($this->Hours) ? $this->Hours : null;
    }
    /**
     * Set Hours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $hours
     * @return \StructType\Course
     */
    public function setHours($hours = null)
    {
        if (is_null($hours) || (is_array($hours) && empty($hours))) {
            unset($this->Hours);
        } else {
            $this->Hours = $hours;
        }
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\EncodedValue|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \StructType\EncodedValue $image
     * @return \StructType\Course
     */
    public function setImage(\StructType\EncodedValue $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get Index value
     * @return \StructType\EncodedValue|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param \StructType\EncodedValue $index
     * @return \StructType\Course
     */
    public function setIndex(\StructType\EncodedValue $index = null)
    {
        $this->Index = $index;
        return $this;
    }
    /**
     * Get Demo value
     * @return \StructType\EncodedValue|null
     */
    public function getDemo()
    {
        return $this->Demo;
    }
    /**
     * Set Demo value
     * @param \StructType\EncodedValue $demo
     * @return \StructType\Course
     */
    public function setDemo(\StructType\EncodedValue $demo = null)
    {
        $this->Demo = $demo;
        return $this;
    }
    /**
     * Get ReleaseDate value
     * @return \StructType\Date|null
     */
    public function getReleaseDate()
    {
        return $this->ReleaseDate;
    }
    /**
     * Set ReleaseDate value
     * @param \StructType\Date $releaseDate
     * @return \StructType\Course
     */
    public function setReleaseDate(\StructType\Date $releaseDate = null)
    {
        $this->ReleaseDate = $releaseDate;
        return $this;
    }
    /**
     * Get DiscontinueDate value
     * @return \StructType\Date|null
     */
    public function getDiscontinueDate()
    {
        return $this->DiscontinueDate;
    }
    /**
     * Set DiscontinueDate value
     * @param \StructType\Date $discontinueDate
     * @return \StructType\Course
     */
    public function setDiscontinueDate(\StructType\Date $discontinueDate = null)
    {
        $this->DiscontinueDate = $discontinueDate;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return \StructType\Date|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param \StructType\Date $lastModifiedDate
     * @return \StructType\Course
     */
    public function setLastModifiedDate(\StructType\Date $lastModifiedDate = null)
    {
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\Course
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get StartDates value
     * @return \ArrayType\ArrayOfDate|null
     */
    public function getStartDates()
    {
        return $this->StartDates;
    }
    /**
     * Set StartDates value
     * @param \ArrayType\ArrayOfDate $startDates
     * @return \StructType\Course
     */
    public function setStartDates(\ArrayType\ArrayOfDate $startDates = null)
    {
        $this->StartDates = $startDates;
        return $this;
    }
    /**
     * Get RelatedCourses value
     * @return \ArrayType\ArrayOfCourseCode|null
     */
    public function getRelatedCourses()
    {
        return $this->RelatedCourses;
    }
    /**
     * Set RelatedCourses value
     * @param \ArrayType\ArrayOfCourseCode $relatedCourses
     * @return \StructType\Course
     */
    public function setRelatedCourses(\ArrayType\ArrayOfCourseCode $relatedCourses = null)
    {
        $this->RelatedCourses = $relatedCourses;
        return $this;
    }
    /**
     * Get StudentReviews value
     * @return \ArrayType\ArrayOfStudentReview|null
     */
    public function getStudentReviews()
    {
        return $this->StudentReviews;
    }
    /**
     * Set StudentReviews value
     * @param \ArrayType\ArrayOfStudentReview $studentReviews
     * @return \StructType\Course
     */
    public function setStudentReviews(\ArrayType\ArrayOfStudentReview $studentReviews = null)
    {
        $this->StudentReviews = $studentReviews;
        return $this;
    }
    /**
     * Get CategoryIDs value
     * @return \ArrayType\ArrayOfCategoryID|null
     */
    public function getCategoryIDs()
    {
        return $this->CategoryIDs;
    }
    /**
     * Set CategoryIDs value
     * @param \ArrayType\ArrayOfCategoryID $categoryIDs
     * @return \StructType\Course
     */
    public function setCategoryIDs(\ArrayType\ArrayOfCategoryID $categoryIDs = null)
    {
        $this->CategoryIDs = $categoryIDs;
        return $this;
    }
    /**
     * Get CourseCode value
     * @return string|null
     */
    public function getCourseCode()
    {
        return $this->CourseCode;
    }
    /**
     * Set CourseCode value
     * @param string $courseCode
     * @return \StructType\Course
     */
    public function setCourseCode($courseCode = null)
    {
        // validation for constraint: string
        if (!is_null($courseCode) && !is_string($courseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($courseCode)), __LINE__);
        }
        $this->CourseCode = $courseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Course
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
