<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Category StructType
 * @subpackage Structs
 */
class Category extends AbstractStructBase
{
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CategoryID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncodedValue
     */
    public $Description;
    /**
     * The CourseCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $CourseCodes;
    /**
     * Constructor method for Category
     * @uses Category::setCategoryID()
     * @uses Category::setName()
     * @uses Category::setDescription()
     * @uses Category::setCourseCodes()
     * @param int $categoryID
     * @param \StructType\EncodedValue $name
     * @param \StructType\EncodedValue $description
     * @param \ArrayType\ArrayOfString $courseCodes
     */
    public function __construct($categoryID = null, \StructType\EncodedValue $name = null, \StructType\EncodedValue $description = null, \ArrayType\ArrayOfString $courseCodes = null)
    {
        $this
            ->setCategoryID($categoryID)
            ->setName($name)
            ->setDescription($description)
            ->setCourseCodes($courseCodes);
    }
    /**
     * Get CategoryID value
     * @return int
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \StructType\Category
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\EncodedValue|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\EncodedValue $name
     * @return \StructType\Category
     */
    public function setName(\StructType\EncodedValue $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\EncodedValue|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\EncodedValue $description
     * @return \StructType\Category
     */
    public function setDescription(\StructType\EncodedValue $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CourseCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCourseCodes()
    {
        return $this->CourseCodes;
    }
    /**
     * Set CourseCodes value
     * @param \ArrayType\ArrayOfString $courseCodes
     * @return \StructType\Category
     */
    public function setCourseCodes(\ArrayType\ArrayOfString $courseCodes = null)
    {
        $this->CourseCodes = $courseCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Category
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
