<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Categories StructType
 * @subpackage Structs
 */
class Categories extends AbstractStructBase
{
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Category[]
     */
    public $Category;
    /**
     * Constructor method for Categories
     * @uses Categories::setCategory()
     * @param \StructType\Category[] $category
     */
    public function __construct(array $category = array())
    {
        $this
            ->setCategory($category);
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Category[]|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Category[] $category
     * @return \StructType\Categories
     */
    public function setCategory(array $category = array())
    {
        foreach ($category as $categoriesCategoryItem) {
            // validation for constraint: itemType
            if (!$categoriesCategoryItem instanceof \StructType\Category) {
                throw new \InvalidArgumentException(sprintf('The Category property can only contain items of \StructType\Category, "%s" given', is_object($categoriesCategoryItem) ? get_class($categoriesCategoryItem) : gettype($categoriesCategoryItem)), __LINE__);
            }
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Add item to Category value
     * @throws \InvalidArgumentException
     * @param \StructType\Category $item
     * @return \StructType\Categories
     */
    public function addToCategory(\StructType\Category $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Category) {
            throw new \InvalidArgumentException(sprintf('The Category property can only contain items of \StructType\Category, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Category[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Categories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
