<?php

namespace EnumType;

/**
 * This class stands for CourseIncludeField EnumType
 * @subpackage Enumerations
 */
class CourseIncludeField
{
    /**
     * Constant for value 'CategoryIDs'
     * @return string 'CategoryIDs'
     */
    const VALUE_CATEGORY_IDS = 'CategoryIDs';
    /**
     * Constant for value 'Demo'
     * @return string 'Demo'
     */
    const VALUE_DEMO = 'Demo';
    /**
     * Constant for value 'Details'
     * @return string 'Details'
     */
    const VALUE_DETAILS = 'Details';
    /**
     * Constant for value 'DiscontinueDate'
     * @return string 'DiscontinueDate'
     */
    const VALUE_DISCONTINUE_DATE = 'DiscontinueDate';
    /**
     * Constant for value 'Duration'
     * @return string 'Duration'
     */
    const VALUE_DURATION = 'Duration';
    /**
     * Constant for value 'FAQs'
     * @return string 'FAQs'
     */
    const VALUE_FAQS = 'FAQs';
    /**
     * Constant for value 'Hours'
     * @return string 'Hours'
     */
    const VALUE_HOURS = 'Hours';
    /**
     * Constant for value 'Image'
     * @return string 'Image'
     */
    const VALUE_IMAGE = 'Image';
    /**
     * Constant for value 'Instructor'
     * @return string 'Instructor'
     */
    const VALUE_INSTRUCTOR = 'Instructor';
    /**
     * Constant for value 'Index'
     * @return string 'Index'
     */
    const VALUE_INDEX = 'Index';
    /**
     * Constant for value 'LastModifiedDate'
     * @return string 'LastModifiedDate'
     */
    const VALUE_LAST_MODIFIED_DATE = 'LastModifiedDate';
    /**
     * Constant for value 'Objectives'
     * @return string 'Objectives'
     */
    const VALUE_OBJECTIVES = 'Objectives';
    /**
     * Constant for value 'Outline'
     * @return string 'Outline'
     */
    const VALUE_OUTLINE = 'Outline';
    /**
     * Constant for value 'Overview'
     * @return string 'Overview'
     */
    const VALUE_OVERVIEW = 'Overview';
    /**
     * Constant for value 'Prerequisites'
     * @return string 'Prerequisites'
     */
    const VALUE_PREREQUISITES = 'Prerequisites';
    /**
     * Constant for value 'RelatedCourses'
     * @return string 'RelatedCourses'
     */
    const VALUE_RELATED_COURSES = 'RelatedCourses';
    /**
     * Constant for value 'ReleaseDate'
     * @return string 'ReleaseDate'
     */
    const VALUE_RELEASE_DATE = 'ReleaseDate';
    /**
     * Constant for value 'Requirements'
     * @return string 'Requirements'
     */
    const VALUE_REQUIREMENTS = 'Requirements';
    /**
     * Constant for value 'StartDates'
     * @return string 'StartDates'
     */
    const VALUE_START_DATES = 'StartDates';
    /**
     * Constant for value 'StudentReviews'
     * @return string 'StudentReviews'
     */
    const VALUE_STUDENT_REVIEWS = 'StudentReviews';
    /**
     * Constant for value 'Summary'
     * @return string 'Summary'
     */
    const VALUE_SUMMARY = 'Summary';
    /**
     * Constant for value 'Title'
     * @return string 'Title'
     */
    const VALUE_TITLE = 'Title';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CATEGORY_IDS
     * @uses self::VALUE_DEMO
     * @uses self::VALUE_DETAILS
     * @uses self::VALUE_DISCONTINUE_DATE
     * @uses self::VALUE_DURATION
     * @uses self::VALUE_FAQS
     * @uses self::VALUE_HOURS
     * @uses self::VALUE_IMAGE
     * @uses self::VALUE_INSTRUCTOR
     * @uses self::VALUE_INDEX
     * @uses self::VALUE_LAST_MODIFIED_DATE
     * @uses self::VALUE_OBJECTIVES
     * @uses self::VALUE_OUTLINE
     * @uses self::VALUE_OVERVIEW
     * @uses self::VALUE_PREREQUISITES
     * @uses self::VALUE_RELATED_COURSES
     * @uses self::VALUE_RELEASE_DATE
     * @uses self::VALUE_REQUIREMENTS
     * @uses self::VALUE_START_DATES
     * @uses self::VALUE_STUDENT_REVIEWS
     * @uses self::VALUE_SUMMARY
     * @uses self::VALUE_TITLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CATEGORY_IDS,
            self::VALUE_DEMO,
            self::VALUE_DETAILS,
            self::VALUE_DISCONTINUE_DATE,
            self::VALUE_DURATION,
            self::VALUE_FAQS,
            self::VALUE_HOURS,
            self::VALUE_IMAGE,
            self::VALUE_INSTRUCTOR,
            self::VALUE_INDEX,
            self::VALUE_LAST_MODIFIED_DATE,
            self::VALUE_OBJECTIVES,
            self::VALUE_OUTLINE,
            self::VALUE_OVERVIEW,
            self::VALUE_PREREQUISITES,
            self::VALUE_RELATED_COURSES,
            self::VALUE_RELEASE_DATE,
            self::VALUE_REQUIREMENTS,
            self::VALUE_START_DATES,
            self::VALUE_STUDENT_REVIEWS,
            self::VALUE_SUMMARY,
            self::VALUE_TITLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
