<?php

namespace CourseInfoClasses;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get CourseInfoClasses
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCategories
     * Meta informations extracted from the WSDL
     * - documentation: Returns list of category info objects.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CourseInformationService&m=GetCategories'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCategories $parameters
     * @return \StructType\GetCategoriesResponse|bool
     */
    public function GetCategories(\StructType\GetCategories $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCategoryList
     * Meta informations extracted from the WSDL
     * - documentation: Gets top level category tree.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CourseInformationService&m=GetCategoryList'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCategoryList $parameters
     * @return \StructType\GetCategoryListResponse|bool
     */
    public function GetCategoryList(\StructType\GetCategoryList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCategoryList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCourses
     * Meta informations extracted from the WSDL
     * - documentation: Gets courses offered by site found using provided filter and returning fields specified.<br/>&nbsp;<i>For details see <a href='./Instructions.aspx?s=CourseInformationService&m=GetCourses'>Instructions</a></i>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCourses $parameters
     * @return \StructType\GetCoursesResponse|bool
     */
    public function GetCourses(\StructType\GetCourses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCourses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCategoriesResponse|\StructType\GetCategoryListResponse|\StructType\GetCoursesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
