<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString1 extends AbstractStructArrayBase
{
    /**
     * The SearchTerm
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $SearchTerm;
    /**
     * Constructor method for ArrayOfString1
     * @uses ArrayOfString1::setSearchTerm()
     * @param string[] $searchTerm
     */
    public function __construct(array $searchTerm = array())
    {
        $this
            ->setSearchTerm($searchTerm);
    }
    /**
     * Get SearchTerm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSearchTerm()
    {
        return isset($this->SearchTerm) ? $this->SearchTerm : null;
    }
    /**
     * Set SearchTerm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $searchTerm
     * @return \ArrayType\ArrayOfString1
     */
    public function setSearchTerm(array $searchTerm = array())
    {
        foreach ($searchTerm as $arrayOfString1SearchTermItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString1SearchTermItem)) {
                throw new \InvalidArgumentException(sprintf('The SearchTerm property can only contain items of string, "%s" given', is_object($arrayOfString1SearchTermItem) ? get_class($arrayOfString1SearchTermItem) : gettype($arrayOfString1SearchTermItem)), __LINE__);
            }
        }
        if (is_null($searchTerm) || (is_array($searchTerm) && empty($searchTerm))) {
            unset($this->SearchTerm);
        } else {
            $this->SearchTerm = $searchTerm;
        }
        return $this;
    }
    /**
     * Add item to SearchTerm value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString1
     */
    public function addToSearchTerm($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SearchTerm property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SearchTerm[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SearchTerm
     */
    public function getAttributeName()
    {
        return 'SearchTerm';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
