<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDate ArrayType
 * @subpackage Arrays
 */
class ArrayOfDate extends AbstractStructArrayBase
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Date[]
     */
    public $StartDate;
    /**
     * Constructor method for ArrayOfDate
     * @uses ArrayOfDate::setStartDate()
     * @param \StructType\Date[] $startDate
     */
    public function __construct(array $startDate = array())
    {
        $this
            ->setStartDate($startDate);
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Date[]|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $startDate
     * @return \ArrayType\ArrayOfDate
     */
    public function setStartDate(array $startDate = array())
    {
        foreach ($startDate as $arrayOfDateStartDateItem) {
            // validation for constraint: itemType
            if (!$arrayOfDateStartDateItem instanceof \StructType\Date) {
                throw new \InvalidArgumentException(sprintf('The StartDate property can only contain items of \StructType\Date, "%s" given', is_object($arrayOfDateStartDateItem) ? get_class($arrayOfDateStartDateItem) : gettype($arrayOfDateStartDateItem)), __LINE__);
            }
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Add item to StartDate value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \ArrayType\ArrayOfDate
     */
    public function addToStartDate(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The StartDate property can only contain items of \StructType\Date, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StartDate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Date|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Date|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Date|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Date|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Date|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string StartDate
     */
    public function getAttributeName()
    {
        return 'StartDate';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
