<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCourseIncludeField ArrayType
 * @subpackage Arrays
 */
class ArrayOfCourseIncludeField extends AbstractStructArrayBase
{
    /**
     * The FieldName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $FieldName;
    /**
     * Constructor method for ArrayOfCourseIncludeField
     * @uses ArrayOfCourseIncludeField::setFieldName()
     * @param string[] $fieldName
     */
    public function __construct(array $fieldName = array())
    {
        $this
            ->setFieldName($fieldName);
    }
    /**
     * Get FieldName value
     * @return string[]|null
     */
    public function getFieldName()
    {
        return $this->FieldName;
    }
    /**
     * Set FieldName value
     * @uses \EnumType\CourseIncludeField::valueIsValid()
     * @uses \EnumType\CourseIncludeField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $fieldName
     * @return \ArrayType\ArrayOfCourseIncludeField
     */
    public function setFieldName(array $fieldName = array())
    {
        $invalidValues = array();
        foreach ($fieldName as $arrayOfCourseIncludeFieldFieldNameItem) {
            if (!\EnumType\CourseIncludeField::valueIsValid($arrayOfCourseIncludeFieldFieldNameItem)) {
                $invalidValues[] = var_export($arrayOfCourseIncludeFieldFieldNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\CourseIncludeField::getValidValues())), __LINE__);
        }
        $this->FieldName = $fieldName;
        return $this;
    }
    /**
     * Add item to FieldName value
     * @uses \EnumType\CourseIncludeField::valueIsValid()
     * @uses \EnumType\CourseIncludeField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfCourseIncludeField
     */
    public function addToFieldName($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CourseIncludeField::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\CourseIncludeField::getValidValues())), __LINE__);
        }
        $this->FieldName[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\CourseIncludeField::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfCourseIncludeField
     */
    public function add($item)
    {
        if (!\EnumType\CourseIncludeField::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\CourseIncludeField::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FieldName
     */
    public function getAttributeName()
    {
        return 'FieldName';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCourseIncludeField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
