<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCourseCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfCourseCode extends AbstractStructArrayBase
{
    /**
     * The CourseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CourseCode[]
     */
    public $CourseCode;
    /**
     * Constructor method for ArrayOfCourseCode
     * @uses ArrayOfCourseCode::setCourseCode()
     * @param \StructType\CourseCode[] $courseCode
     */
    public function __construct(array $courseCode = array())
    {
        $this
            ->setCourseCode($courseCode);
    }
    /**
     * Get CourseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CourseCode[]|null
     */
    public function getCourseCode()
    {
        return isset($this->CourseCode) ? $this->CourseCode : null;
    }
    /**
     * Set CourseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CourseCode[] $courseCode
     * @return \ArrayType\ArrayOfCourseCode
     */
    public function setCourseCode(array $courseCode = array())
    {
        foreach ($courseCode as $arrayOfCourseCodeCourseCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfCourseCodeCourseCodeItem instanceof \StructType\CourseCode) {
                throw new \InvalidArgumentException(sprintf('The CourseCode property can only contain items of \StructType\CourseCode, "%s" given', is_object($arrayOfCourseCodeCourseCodeItem) ? get_class($arrayOfCourseCodeCourseCodeItem) : gettype($arrayOfCourseCodeCourseCodeItem)), __LINE__);
            }
        }
        if (is_null($courseCode) || (is_array($courseCode) && empty($courseCode))) {
            unset($this->CourseCode);
        } else {
            $this->CourseCode = $courseCode;
        }
        return $this;
    }
    /**
     * Add item to CourseCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CourseCode $item
     * @return \ArrayType\ArrayOfCourseCode
     */
    public function addToCourseCode(\StructType\CourseCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CourseCode) {
            throw new \InvalidArgumentException(sprintf('The CourseCode property can only contain items of \StructType\CourseCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CourseCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CourseCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CourseCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CourseCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CourseCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CourseCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CourseCode
     */
    public function getAttributeName()
    {
        return 'CourseCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCourseCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
