<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCourse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCourse extends AbstractStructArrayBase
{
    /**
     * The Course
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Course[]
     */
    public $Course;
    /**
     * Constructor method for ArrayOfCourse
     * @uses ArrayOfCourse::setCourse()
     * @param \StructType\Course[] $course
     */
    public function __construct(array $course = array())
    {
        $this
            ->setCourse($course);
    }
    /**
     * Get Course value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Course[]|null
     */
    public function getCourse()
    {
        return isset($this->Course) ? $this->Course : null;
    }
    /**
     * Set Course value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Course[] $course
     * @return \ArrayType\ArrayOfCourse
     */
    public function setCourse(array $course = array())
    {
        foreach ($course as $arrayOfCourseCourseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCourseCourseItem instanceof \StructType\Course) {
                throw new \InvalidArgumentException(sprintf('The Course property can only contain items of \StructType\Course, "%s" given', is_object($arrayOfCourseCourseItem) ? get_class($arrayOfCourseCourseItem) : gettype($arrayOfCourseCourseItem)), __LINE__);
            }
        }
        if (is_null($course) || (is_array($course) && empty($course))) {
            unset($this->Course);
        } else {
            $this->Course = $course;
        }
        return $this;
    }
    /**
     * Add item to Course value
     * @throws \InvalidArgumentException
     * @param \StructType\Course $item
     * @return \ArrayType\ArrayOfCourse
     */
    public function addToCourse(\StructType\Course $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Course) {
            throw new \InvalidArgumentException(sprintf('The Course property can only contain items of \StructType\Course, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Course[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Course|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Course|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Course|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Course|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Course|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Course
     */
    public function getAttributeName()
    {
        return 'Course';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCourse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
