<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCategoryID ArrayType
 * @subpackage Arrays
 */
class ArrayOfCategoryID extends AbstractStructArrayBase
{
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CategoryID[]
     */
    public $CategoryID;
    /**
     * Constructor method for ArrayOfCategoryID
     * @uses ArrayOfCategoryID::setCategoryID()
     * @param \StructType\CategoryID[] $categoryID
     */
    public function __construct(array $categoryID = array())
    {
        $this
            ->setCategoryID($categoryID);
    }
    /**
     * Get CategoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CategoryID[]|null
     */
    public function getCategoryID()
    {
        return isset($this->CategoryID) ? $this->CategoryID : null;
    }
    /**
     * Set CategoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryID[] $categoryID
     * @return \ArrayType\ArrayOfCategoryID
     */
    public function setCategoryID(array $categoryID = array())
    {
        foreach ($categoryID as $arrayOfCategoryIDCategoryIDItem) {
            // validation for constraint: itemType
            if (!$arrayOfCategoryIDCategoryIDItem instanceof \StructType\CategoryID) {
                throw new \InvalidArgumentException(sprintf('The CategoryID property can only contain items of \StructType\CategoryID, "%s" given', is_object($arrayOfCategoryIDCategoryIDItem) ? get_class($arrayOfCategoryIDCategoryIDItem) : gettype($arrayOfCategoryIDCategoryIDItem)), __LINE__);
            }
        }
        if (is_null($categoryID) || (is_array($categoryID) && empty($categoryID))) {
            unset($this->CategoryID);
        } else {
            $this->CategoryID = $categoryID;
        }
        return $this;
    }
    /**
     * Add item to CategoryID value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryID $item
     * @return \ArrayType\ArrayOfCategoryID
     */
    public function addToCategoryID(\StructType\CategoryID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryID) {
            throw new \InvalidArgumentException(sprintf('The CategoryID property can only contain items of \StructType\CategoryID, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CategoryID[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CategoryID|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CategoryID|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CategoryID|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CategoryID|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CategoryID|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CategoryID
     */
    public function getAttributeName()
    {
        return 'CategoryID';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCategoryID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
