<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pay360sc.e-paycapita.com/LivePayments242/PortalService.svc?singlewsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://pay360sc.e-paycapita.com/LivePayments242/PortalService.svc?singlewsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for Cancel operation/method
 */
if ($cancel->Cancel(new \StructType\Cancel()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Invoke ServiceType
 */
$invoke = new \ServiceType\Invoke($options);
/**
 * Sample call for Invoke operation/method
 */
if ($invoke->Invoke(new \StructType\Invoke()) !== false) {
    print_r($invoke->getResult());
} else {
    print_r($invoke->getLastError());
}
/**
 * Samples for Progress ServiceType
 */
$progress = new \ServiceType\Progress($options);
/**
 * Sample call for Progress operation/method
 */
if ($progress->Progress(new \StructType\Progress()) !== false) {
    print_r($progress->getResult());
} else {
    print_r($progress->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \ServiceType\Query($options);
/**
 * Sample call for Query operation/method
 */
if ($query->Query(new \StructType\Query()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePassword operation/method
 */
if ($update->UpdatePassword(new \StructType\UpdatePassword()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
