<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for threePartName StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:threePartName
 * @subpackage Structs
 */
class ThreePartName extends AbstractStructBase
{
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $surname;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $title;
    /**
     * The forename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $forename;
    /**
     * Constructor method for threePartName
     * @uses ThreePartName::setSurname()
     * @uses ThreePartName::setTitle()
     * @uses ThreePartName::setForename()
     * @param string $surname
     * @param string $title
     * @param string $forename
     */
    public function __construct($surname = null, $title = null, $forename = null)
    {
        $this
            ->setSurname($surname)
            ->setTitle($title)
            ->setForename($forename);
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \StructType\ThreePartName
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : null;
    }
    /**
     * Set title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\ThreePartName
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->title);
        } else {
            $this->title = $title;
        }
        return $this;
    }
    /**
     * Get forename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForename()
    {
        return isset($this->forename) ? $this->forename : null;
    }
    /**
     * Set forename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forename
     * @return \StructType\ThreePartName
     */
    public function setForename($forename = null)
    {
        // validation for constraint: string
        if (!is_null($forename) && !is_string($forename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forename)), __LINE__);
        }
        if (is_null($forename) || (is_array($forename) && empty($forename))) {
            unset($this->forename);
        } else {
            $this->forename = $forename;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ThreePartName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
