<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for surchargeBasis StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:surchargeBasis
 * @subpackage Structs
 */
class SurchargeBasis extends AbstractStructBase
{
    /**
     * The surchargeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surchargeType;
    /**
     * The surchargeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $surchargeRate;
    /**
     * Constructor method for surchargeBasis
     * @uses SurchargeBasis::setSurchargeType()
     * @uses SurchargeBasis::setSurchargeRate()
     * @param string $surchargeType
     * @param float $surchargeRate
     */
    public function __construct($surchargeType = null, $surchargeRate = null)
    {
        $this
            ->setSurchargeType($surchargeType)
            ->setSurchargeRate($surchargeRate);
    }
    /**
     * Get surchargeType value
     * @return string|null
     */
    public function getSurchargeType()
    {
        return $this->surchargeType;
    }
    /**
     * Set surchargeType value
     * @uses \EnumType\SurchargeTypes::valueIsValid()
     * @uses \EnumType\SurchargeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $surchargeType
     * @return \StructType\SurchargeBasis
     */
    public function setSurchargeType($surchargeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SurchargeTypes::valueIsValid($surchargeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $surchargeType, implode(', ', \EnumType\SurchargeTypes::getValidValues())), __LINE__);
        }
        $this->surchargeType = $surchargeType;
        return $this;
    }
    /**
     * Get surchargeRate value
     * @return float|null
     */
    public function getSurchargeRate()
    {
        return $this->surchargeRate;
    }
    /**
     * Set surchargeRate value
     * @param float $surchargeRate
     * @return \StructType\SurchargeBasis
     */
    public function setSurchargeRate($surchargeRate = null)
    {
        $this->surchargeRate = $surchargeRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurchargeBasis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
