<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeCardResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:storeCardResult
 * @subpackage Structs
 */
class StoreCardResult extends AbstractStructBase
{
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The cssCardType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cssCardType;
    /**
     * The lastFour
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastFour;
    /**
     * The mnemonic
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mnemonic;
    /**
     * The token
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $token;
    /**
     * Constructor method for storeCardResult
     * @uses StoreCardResult::setStatus()
     * @uses StoreCardResult::setCssCardType()
     * @uses StoreCardResult::setLastFour()
     * @uses StoreCardResult::setMnemonic()
     * @uses StoreCardResult::setToken()
     * @param string $status
     * @param string $cssCardType
     * @param string $lastFour
     * @param string $mnemonic
     * @param string $token
     */
    public function __construct($status = null, $cssCardType = null, $lastFour = null, $mnemonic = null, $token = null)
    {
        $this
            ->setStatus($status)
            ->setCssCardType($cssCardType)
            ->setLastFour($lastFour)
            ->setMnemonic($mnemonic)
            ->setToken($token);
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StoreCardStatus::valueIsValid()
     * @uses \EnumType\StoreCardStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\StoreCardResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StoreCardStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\StoreCardStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get cssCardType value
     * @return string|null
     */
    public function getCssCardType()
    {
        return $this->cssCardType;
    }
    /**
     * Set cssCardType value
     * @param string $cssCardType
     * @return \StructType\StoreCardResult
     */
    public function setCssCardType($cssCardType = null)
    {
        // validation for constraint: string
        if (!is_null($cssCardType) && !is_string($cssCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cssCardType)), __LINE__);
        }
        $this->cssCardType = $cssCardType;
        return $this;
    }
    /**
     * Get lastFour value
     * @return string|null
     */
    public function getLastFour()
    {
        return $this->lastFour;
    }
    /**
     * Set lastFour value
     * @param string $lastFour
     * @return \StructType\StoreCardResult
     */
    public function setLastFour($lastFour = null)
    {
        // validation for constraint: string
        if (!is_null($lastFour) && !is_string($lastFour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastFour)), __LINE__);
        }
        $this->lastFour = $lastFour;
        return $this;
    }
    /**
     * Get mnemonic value
     * @return string|null
     */
    public function getMnemonic()
    {
        return $this->mnemonic;
    }
    /**
     * Set mnemonic value
     * @param string $mnemonic
     * @return \StructType\StoreCardResult
     */
    public function setMnemonic($mnemonic = null)
    {
        // validation for constraint: string
        if (!is_null($mnemonic) && !is_string($mnemonic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mnemonic)), __LINE__);
        }
        $this->mnemonic = $mnemonic;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\StoreCardResult
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreCardResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
