<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sale StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:sale
 * @subpackage Structs
 */
class Sale extends AbstractStructBase
{
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfitem
     */
    public $items;
    /**
     * The receiptDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactDetails
     */
    public $receiptDetails;
    /**
     * Constructor method for sale
     * @uses Sale::setItems()
     * @uses Sale::setReceiptDetails()
     * @param \ArrayType\ArrayOfitem $items
     * @param \StructType\ContactDetails $receiptDetails
     */
    public function __construct(\ArrayType\ArrayOfitem $items = null, \StructType\ContactDetails $receiptDetails = null)
    {
        $this
            ->setItems($items)
            ->setReceiptDetails($receiptDetails);
    }
    /**
     * Get items value
     * @return \ArrayType\ArrayOfitem|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \ArrayType\ArrayOfitem $items
     * @return \StructType\Sale
     */
    public function setItems(\ArrayType\ArrayOfitem $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get receiptDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactDetails|null
     */
    public function getReceiptDetails()
    {
        return isset($this->receiptDetails) ? $this->receiptDetails : null;
    }
    /**
     * Set receiptDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ContactDetails $receiptDetails
     * @return \StructType\Sale
     */
    public function setReceiptDetails(\StructType\ContactDetails $receiptDetails = null)
    {
        if (is_null($receiptDetails) || (is_array($receiptDetails) && empty($receiptDetails))) {
            unset($this->receiptDetails);
        } else {
            $this->receiptDetails = $receiptDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sale
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
