<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for progressResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:progressResult
 * @subpackage Structs
 */
class ProgressResult extends BaseResult
{
    /**
     * The progress
     * @var string
     */
    public $progress;
    /**
     * Constructor method for progressResult
     * @uses ProgressResult::setProgress()
     * @param string $progress
     */
    public function __construct($progress = null)
    {
        $this
            ->setProgress($progress);
    }
    /**
     * Get progress value
     * @return string|null
     */
    public function getProgress()
    {
        return $this->progress;
    }
    /**
     * Set progress value
     * @uses \EnumType\ProgressState::valueIsValid()
     * @uses \EnumType\ProgressState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $progress
     * @return \StructType\ProgressResult
     */
    public function setProgress($progress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProgressState::valueIsValid($progress)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $progress, implode(', ', \EnumType\ProgressState::getValidValues())), __LINE__);
        }
        $this->progress = $progress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProgressResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
