<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentSummary StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:paymentSummary
 * @subpackage Structs
 */
class PaymentSummary extends AbstractStructBase
{
    /**
     * The payCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $payCode;
    /**
     * The continuousAuditNumber
     * @var int
     */
    public $continuousAuditNumber;
    /**
     * Constructor method for paymentSummary
     * @uses PaymentSummary::setPayCode()
     * @uses PaymentSummary::setContinuousAuditNumber()
     * @param string $payCode
     * @param int $continuousAuditNumber
     */
    public function __construct($payCode = null, $continuousAuditNumber = null)
    {
        $this
            ->setPayCode($payCode)
            ->setContinuousAuditNumber($continuousAuditNumber);
    }
    /**
     * Get payCode value
     * @return string|null
     */
    public function getPayCode()
    {
        return $this->payCode;
    }
    /**
     * Set payCode value
     * @param string $payCode
     * @return \StructType\PaymentSummary
     */
    public function setPayCode($payCode = null)
    {
        // validation for constraint: string
        if (!is_null($payCode) && !is_string($payCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payCode)), __LINE__);
        }
        $this->payCode = $payCode;
        return $this;
    }
    /**
     * Get continuousAuditNumber value
     * @return int|null
     */
    public function getContinuousAuditNumber()
    {
        return $this->continuousAuditNumber;
    }
    /**
     * Set continuousAuditNumber value
     * @param int $continuousAuditNumber
     * @return \StructType\PaymentSummary
     */
    public function setContinuousAuditNumber($continuousAuditNumber = null)
    {
        // validation for constraint: int
        if (!is_null($continuousAuditNumber) && !is_numeric($continuousAuditNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($continuousAuditNumber)), __LINE__);
        }
        $this->continuousAuditNumber = $continuousAuditNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
