<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:itemDetails
 * @subpackage Structs
 */
class ItemDetails extends AbstractStructBase
{
    /**
     * The fundCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fundCode;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The shortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $shortCode;
    /**
     * The amountInMinorUnits
     * @var int
     */
    public $amountInMinorUnits;
    /**
     * The additionalInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalInfo
     */
    public $additionalInfo;
    /**
     * The accountDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactDetails
     */
    public $accountDetails;
    /**
     * Constructor method for itemDetails
     * @uses ItemDetails::setFundCode()
     * @uses ItemDetails::setReference()
     * @uses ItemDetails::setShortCode()
     * @uses ItemDetails::setAmountInMinorUnits()
     * @uses ItemDetails::setAdditionalInfo()
     * @uses ItemDetails::setAccountDetails()
     * @param string $fundCode
     * @param string $reference
     * @param string $shortCode
     * @param int $amountInMinorUnits
     * @param \StructType\AdditionalInfo $additionalInfo
     * @param \StructType\ContactDetails $accountDetails
     */
    public function __construct($fundCode = null, $reference = null, $shortCode = null, $amountInMinorUnits = null, \StructType\AdditionalInfo $additionalInfo = null, \StructType\ContactDetails $accountDetails = null)
    {
        $this
            ->setFundCode($fundCode)
            ->setReference($reference)
            ->setShortCode($shortCode)
            ->setAmountInMinorUnits($amountInMinorUnits)
            ->setAdditionalInfo($additionalInfo)
            ->setAccountDetails($accountDetails);
    }
    /**
     * Get fundCode value
     * @return string|null
     */
    public function getFundCode()
    {
        return $this->fundCode;
    }
    /**
     * Set fundCode value
     * @param string $fundCode
     * @return \StructType\ItemDetails
     */
    public function setFundCode($fundCode = null)
    {
        // validation for constraint: string
        if (!is_null($fundCode) && !is_string($fundCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fundCode)), __LINE__);
        }
        $this->fundCode = $fundCode;
        return $this;
    }
    /**
     * Get reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->reference) ? $this->reference : null;
    }
    /**
     * Set reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \StructType\ItemDetails
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->reference);
        } else {
            $this->reference = $reference;
        }
        return $this;
    }
    /**
     * Get shortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortCode()
    {
        return isset($this->shortCode) ? $this->shortCode : null;
    }
    /**
     * Set shortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortCode
     * @return \StructType\ItemDetails
     */
    public function setShortCode($shortCode = null)
    {
        // validation for constraint: string
        if (!is_null($shortCode) && !is_string($shortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortCode)), __LINE__);
        }
        if (is_null($shortCode) || (is_array($shortCode) && empty($shortCode))) {
            unset($this->shortCode);
        } else {
            $this->shortCode = $shortCode;
        }
        return $this;
    }
    /**
     * Get amountInMinorUnits value
     * @return int|null
     */
    public function getAmountInMinorUnits()
    {
        return $this->amountInMinorUnits;
    }
    /**
     * Set amountInMinorUnits value
     * @param int $amountInMinorUnits
     * @return \StructType\ItemDetails
     */
    public function setAmountInMinorUnits($amountInMinorUnits = null)
    {
        // validation for constraint: int
        if (!is_null($amountInMinorUnits) && !is_numeric($amountInMinorUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amountInMinorUnits)), __LINE__);
        }
        $this->amountInMinorUnits = $amountInMinorUnits;
        return $this;
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalInfo|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdditionalInfo $additionalInfo
     * @return \StructType\ItemDetails
     */
    public function setAdditionalInfo(\StructType\AdditionalInfo $additionalInfo = null)
    {
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Get accountDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactDetails|null
     */
    public function getAccountDetails()
    {
        return isset($this->accountDetails) ? $this->accountDetails : null;
    }
    /**
     * Set accountDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ContactDetails $accountDetails
     * @return \StructType\ItemDetails
     */
    public function setAccountDetails(\StructType\ContactDetails $accountDetails = null)
    {
        if (is_null($accountDetails) || (is_array($accountDetails) && empty($accountDetails))) {
            unset($this->accountDetails);
        } else {
            $this->accountDetails = $accountDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
