<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for credentials StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:credentials
 * @subpackage Structs
 */
class Credentials extends AbstractStructBase
{
    /**
     * The subject
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Subject
     */
    public $subject;
    /**
     * The requestIdentification
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\RequestIdentification
     */
    public $requestIdentification;
    /**
     * The signature
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Signature
     */
    public $signature;
    /**
     * Constructor method for credentials
     * @uses Credentials::setSubject()
     * @uses Credentials::setRequestIdentification()
     * @uses Credentials::setSignature()
     * @param \StructType\Subject $subject
     * @param \StructType\RequestIdentification $requestIdentification
     * @param \StructType\Signature $signature
     */
    public function __construct(\StructType\Subject $subject = null, \StructType\RequestIdentification $requestIdentification = null, \StructType\Signature $signature = null)
    {
        $this
            ->setSubject($subject)
            ->setRequestIdentification($requestIdentification)
            ->setSignature($signature);
    }
    /**
     * Get subject value
     * @return \StructType\Subject|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param \StructType\Subject $subject
     * @return \StructType\Credentials
     */
    public function setSubject(\StructType\Subject $subject = null)
    {
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get requestIdentification value
     * @return \StructType\RequestIdentification|null
     */
    public function getRequestIdentification()
    {
        return $this->requestIdentification;
    }
    /**
     * Set requestIdentification value
     * @param \StructType\RequestIdentification $requestIdentification
     * @return \StructType\Credentials
     */
    public function setRequestIdentification(\StructType\RequestIdentification $requestIdentification = null)
    {
        $this->requestIdentification = $requestIdentification;
        return $this;
    }
    /**
     * Get signature value
     * @return \StructType\Signature|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @param \StructType\Signature $signature
     * @return \StructType\Credentials
     */
    public function setSignature(\StructType\Signature $signature = null)
    {
        $this->signature = $signature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Credentials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
