<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseResult
 * @subpackage Structs
 */
class BaseResult extends AbstractStructBase
{
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The errorDetails
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ErrorDetails
     */
    public $errorDetails;
    /**
     * Constructor method for BaseResult
     * @uses BaseResult::setStatus()
     * @uses BaseResult::setErrorDetails()
     * @param string $status
     * @param \StructType\ErrorDetails $errorDetails
     */
    public function __construct($status = null, \StructType\ErrorDetails $errorDetails = null)
    {
        $this
            ->setStatus($status)
            ->setErrorDetails($errorDetails);
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\Status::valueIsValid()
     * @uses \EnumType\Status::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BaseResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Status::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\Status::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get errorDetails value
     * @return \StructType\ErrorDetails|null
     */
    public function getErrorDetails()
    {
        return $this->errorDetails;
    }
    /**
     * Set errorDetails value
     * @param \StructType\ErrorDetails $errorDetails
     * @return \StructType\BaseResult
     */
    public function setErrorDetails(\StructType\ErrorDetails $errorDetails = null)
    {
        $this->errorDetails = $errorDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
